/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxLicenseType;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.IEclipseLicenseSettings;
import com.yakindu.licmgmt.internal.LicenseManager;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.internal.LicenseSettings;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.internal.events.LicenseEnabledSettingEvent;
import com.yakindu.licmgmt.internal.events.LicenseNotificationSettingEvent;
import com.yakindu.licmgmt.internal.events.LicenseWarningEvent;
import com.yakindu.licmgmt.internal.preferences.LicensePreferences;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class EclipseLicenseSettings
implements IEclipseLicenseSettings {
    private static final String YLM_PROPERTIES = "ylm.properties";
    private final LicenseService service = (LicenseService)ILicenseService.INSTANCE;
    private final LicenseSettings settings = (LicenseSettings)this.service.getSettings();
    private boolean restartRequiredForChangedSettings = false;

    static {
        EclipseLicenseSettings.initConfigPathProperty();
    }

    private static void initConfigPathProperty() {
        String ylmConfigPath = EclipseLicenseSettings.getYlmConfigPath();
        if (ylmConfigPath != null) {
            LoggingHelper.debug((String)"Found '%s' file in: %s", (Object[])new Object[]{YLM_PROPERTIES, ylmConfigPath});
            System.setProperty("ylm.config.path", ylmConfigPath);
        } else {
            LoggingHelper.debug((String)"Could not find '%s'", (Object[])new Object[]{YLM_PROPERTIES});
        }
    }

    private static String getYlmConfigPath() {
        String ylmConfigPathProperty = EclipseLicenseSettings.getYlmConfigFilePath(System.getProperty("ylm.config.path"));
        if (ylmConfigPathProperty != null) {
            return ylmConfigPathProperty;
        }
        String ylmConfigPathConfigArea = EclipseLicenseSettings.getYlmConfigFilePath(System.getProperty("osgi.configuration.area"));
        if (ylmConfigPathConfigArea != null) {
            return ylmConfigPathConfigArea;
        }
        String ylmConfigPathInstallAreaPath = EclipseLicenseSettings.getYlmConfigFilePath(String.valueOf(System.getProperty("osgi.install.area")) + "configuration");
        if (ylmConfigPathInstallAreaPath != null) {
            return ylmConfigPathInstallAreaPath;
        }
        return null;
    }

    private static String getYlmConfigFilePath(String ylmConfigPath) {
        if (ylmConfigPath == null || ylmConfigPath.trim().isEmpty()) {
            return null;
        }
        if (new File(ylmConfigPath, YLM_PROPERTIES).exists()) {
            return ylmConfigPath;
        }
        try {
            URL ylmConfigUrl = new URL(ylmConfigPath);
            File ylmConfigFile = new File(ylmConfigUrl.getFile(), YLM_PROPERTIES);
            if (ylmConfigFile.exists()) {
                return ylmConfigUrl.getPath();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public EclipseLicenseSettings() {
        this.updateServerSettingsFromPreferences(false);
        this.registerPreferenceListener();
    }

    private void registerPreferenceListener() {
        LicensePreferences.getInstancePreferenceNode().addPreferenceChangeListener(event -> {
            if (LicenseService.DEBUG) {
                System.out.println("EclipseLicenseSettings.registerPrefListenerForServerSettings() -> pref event: " + event);
            }
            if (!Objects.equals(event.getOldValue(), event.getNewValue())) {
                String prefKey = event.getKey();
                if (prefKey.startsWith("floatingLicenseServer")) {
                    this.updateServerSettingsFromPreferences(true);
                } else if (prefKey.startsWith("licenseEnabled_") && prefKey.length() > "licenseEnabled_".length()) {
                    String featureId = prefKey.substring("licenseEnabled_".length());
                    boolean enabled = Boolean.parseBoolean((String)event.getNewValue());
                    this.updateLicenseEnabledSettingFromPreferences(featureId, enabled);
                } else if (prefKey.startsWith("licenseNotification_") && prefKey.length() > "licenseNotification_".length()) {
                    String featureId = prefKey.substring("licenseNotification_".length());
                    boolean enabled = Boolean.parseBoolean((String)event.getNewValue());
                    this.service.postEvent(LicenseNotificationSettingEvent.create((String)featureId, (boolean)enabled));
                }
            }
        });
    }

    private void updateLicenseEnabledSettingFromPreferences(String featureId, boolean enabled) {
        ILicenseManager licenseManager = ILicenseService.INSTANCE.getAllLicenseManagers().stream().filter(manager -> manager.getFeatureId().equals(featureId)).findFirst().orElse(null);
        if (licenseManager != null) {
            if (!enabled && licenseManager.isCheckedOut()) {
                this.restartRequiredForChangedSettings = true;
                this.service.postEvent(LicenseWarningEvent.createRestartRequired());
            } else {
                ((LicenseManager)licenseManager).setEnabled(enabled);
                this.service.postEvent(LicenseEnabledSettingEvent.create((String)featureId, (boolean)enabled));
            }
        }
    }

    private void updateServerSettingsFromPreferences(boolean showUpdateWarning) {
        ServerSettings currentServerSettings;
        ServerSettings newServerSettings = LicensePreferences.getLicenseServer();
        if (!newServerSettings.equals((Object)(currentServerSettings = this.settings.getServerSettings()))) {
            if (!currentServerSettings.isExternal()) {
                if (!this.restartRequiredForChangedSettings && this.isAnyFloatingLicenseCheckedOut()) {
                    this.restartRequiredForChangedSettings = true;
                }
                if (!this.restartRequiredForChangedSettings) {
                    this.settings.setServerSettings(newServerSettings);
                }
            } else if (showUpdateWarning) {
                this.service.postEvent(LicenseWarningEvent.create((String)"Cannot update server settings", (String)("It is not possible to replace external server settings(" + currentServerSettings + ")")));
            }
        }
    }

    private boolean isAnyFloatingLicenseCheckedOut() {
        return this.service.getAllLicenseManagers().stream().anyMatch(licenseManager -> licenseManager.isCheckedOut() && this.isFloatingLicense(licenseManager.getFeatureInfo()));
    }

    private boolean isFloatingLicense(LmxFeatureInfo featureInfo) {
        LmxLicenseType licenseType;
        LmxLicenseType lmxLicenseType = licenseType = featureInfo == null ? null : featureInfo.getLicenseType();
        return LmxLicenseType.LMX_TYPE_LOCAL != licenseType && LmxLicenseType.LMX_TYPE_TRIAL != licenseType;
    }

    public boolean isRestartRequiredForChangedSettings() {
        return this.restartRequiredForChangedSettings;
    }

    @Override
    public boolean isLicenseEnabled(String featureId) {
        return LicensePreferences.isLicenseEnabled(featureId);
    }

    @Override
    public boolean isLicenseNotificationEnabled(String featureId) {
        return LicensePreferences.isLicenseNotification(featureId);
    }

    @Override
    public boolean isLicenseNotificationDialogSuppressed() {
        return LicensePreferences.isLicenseNotificationDialogSuppressed();
    }

    public ServerSettings getServerSettings() {
        return this.settings.getServerSettings();
    }

    public boolean isTrialEnabled() {
        return this.settings.isTrialEnabled();
    }

    public boolean isCheckClientHostIds() {
        return this.settings.isCheckClientHostIds();
    }

    public boolean isAutoBorrowingEnabled() {
        return this.settings.isAutoBorrowingEnabled();
    }

    public int getDaysToNotifySoonExpiringLicenses() {
        return this.settings.getDaysToNotifySoonExpiringLicenses();
    }

    public String getCustomHostId() {
        return this.settings.getCustomHostId();
    }
}

