/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SerializeUtils {
    private static final String SEPARATOR = ",";

    private SerializeUtils() {
    }

    public static String serialize(Map<String, Boolean> map, boolean defaultValue) {
        return map.keySet().stream().filter(key -> SerializeUtils.isNonDefault(map, key, defaultValue)).sorted().reduce((a, b) -> String.valueOf(a) + SEPARATOR + b).orElse(null);
    }

    private static boolean isNonDefault(Map<String, Boolean> map, String key, boolean defaultValue) {
        Boolean value = map.get(key);
        return value != null && defaultValue != value;
    }

    public static Map<String, Boolean> deserialize(String str, boolean defaultValue) {
        if (str == null || str.trim().isEmpty()) {
            return new HashMap<String, Boolean>();
        }
        if (SerializeUtils.isBase64EncodedString(str)) {
            return SerializeUtils.deserializeBase64Map(str);
        }
        String[] values = str.split(SEPARATOR);
        Map<String, Boolean> map = Stream.of(values).collect(Collectors.toMap(x -> x, x -> !defaultValue));
        return map;
    }

    public static boolean isBase64EncodedString(String str) {
        if (str.endsWith("=")) {
            return true;
        }
        return str.startsWith("rO0ABXN");
    }

    private static Map<String, Boolean> deserializeBase64Map(String str) {
        Object mapObject = SerializeUtils.deserializeBase64(str);
        if (mapObject instanceof Map) {
            Map map = (Map)mapObject;
            return map;
        }
        return null;
    }

    private static Object deserializeBase64(String str) {
        Object o;
        try {
            byte[] byteArray = Base64.getDecoder().decode(str);
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(byteArray));
                o = ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        return o;
    }
}

