/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.utils;

import com.yakindu.licmgmt.internal.LicenseManagementActivator;
import com.yakindu.licmgmt.internal.LicenseService;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class VersionHelper {
    public static String getVersion(Supplier<String> productNameForLogEntry) {
        try {
            ClassLoader classLoader = productNameForLogEntry.getClass().getClassLoader();
            return VersionHelper.getVersionFromCaller(classLoader);
        }
        catch (Exception e) {
            String version = VersionHelper.getVersionFromCurrentDate();
            if (!LicenseService.DEBUG) {
                VersionHelper.logUsingFallbackVersion(productNameForLogEntry.get(), e, version);
            }
            return version;
        }
    }

    private static String getVersionFromCaller(ClassLoader classLoader) throws Exception {
        String callingClassName = VersionHelper.getCallingClassName();
        String buildClassName = String.valueOf(callingClassName.substring(0, callingClassName.lastIndexOf(".") + 1)) + "Build";
        Class<?> buildClass = Class.forName(buildClassName, true, classLoader);
        Field yearField = buildClass.getDeclaredField("YEAR");
        Field monthField = buildClass.getDeclaredField("MONTH");
        yearField.setAccessible(true);
        monthField.setAccessible(true);
        short year = yearField.getShort(null);
        byte month = monthField.getByte(null);
        return VersionHelper.formatVersion(year, month);
    }

    private static String getCallingClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 1;
        while (i < stackTrace.length) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (!className.equals(VersionHelper.class.getName()) && className.indexOf("java.lang.Thread") != 0) {
                return className;
            }
            ++i;
        }
        throw new IllegalStateException("Should never happen because this class does not have a main function");
    }

    private static String getVersionFromCurrentDate() {
        LocalDate now = LocalDate.now();
        int shortYear = now.getYear();
        int month = now.getMonthValue();
        return VersionHelper.formatVersion(shortYear, month);
    }

    private static String formatVersion(int year, int month) {
        return String.format("%d.%d", year % 100, month);
    }

    private static void logUsingFallbackVersion(String productNameForLogEntry, Exception e, String version) {
        String msg = String.format("Product version for %s not found, using current date '%s'; this must only happen for development. Cause: %s(%s)", productNameForLogEntry, version, e.getClass().getSimpleName(), e.getMessage());
        LicenseManagementActivator.log(msg, 2, null, false, false);
    }

    public static String getLicmgmtVersion() {
        Bundle bundle = Platform.isRunning() ? Platform.getBundle((String)"com.yakindu.licmgmt.eclipse") : null;
        return bundle == null ? "<unknown>" : String.valueOf(bundle.getVersion());
    }
}

