/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory

@Singleton
class TimedInterface {
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	
	def create vt : createComplexType createTimedInterface(){
		vt.name = iTimed
		vt.features += _op(raiseTimeEvent, _void)
		vt.features += _op(setTimerService, _void)
	}
	
	def timedType() {
		_createCache_createTimedInterface.get(#[])
	}
	
	def dispatch setTimerServiceOp(ComplexType it){
		features.filter(Operation).filter[name === setTimerService].head
	}
	
	def dispatch setTimerServiceOp(Type it){}
	
	def iTimed(){"ITimed"}
	def raiseTimeEvent(){ "RaiseTimeEvent" }
	def setTimerService(){ "SetTimerService" }
}
