/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.codepattern.IVariableCode
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory

/**
 * Defines the members for a timed object. 
 * 
 * TODO: This should be refactored - e.g. virtualTimerInterface has a misleading name and could be implemented using a library.
 */
@Singleton
class TimerService {

	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension IVariableCode
	@Inject protected extension IMethodCode
	@Inject protected extension Documentation

	def create vt : createComplexType createVirtualTimerInterface() {
		vt.name = iTimerService
		vt.features += _op(setTimer, _void)
		vt.features += _op(unsetTimer, _void)
	}

	def virtualTimerType() {
		_createCache_createVirtualTimerInterface.get(#[])
	}

	def setTimer() { "SetTimer" }

	def iTimerService() { "I" + timerService.toFirstUpper }

	def timerService() { "timerService" }

	def unsetTimer() { "UnsetTimer" }
	
	def timeEventsName() { "timeEvents" }

	def defineTimerServiceSetter() {
		_op("set" + timerService.toFirstUpper, _void) => [
			val param = createParameter => [
				name = timerService + 'ToRegister'
				typeSpecifier = createTypeSpecifier => [ ts |
					ts.type = virtualTimerType
				]
			]
			parameters += param
			_public
			static = false
			implementation = _block(timerServiceVariable._ref._assignment(param._ref))
			generateDefinitionWith[methodDefinitionCode]
		]
	}

	def create it : _variable(timerService, virtualTimerType) timerServiceVariable() {
		documentation("Timer service for timed events.")
		_private
		const = false
		static = true
		generateDeclarationWith[variableDeclarationCode]
	}
	
	def create it : _variable(timeEventsName, createArrayTypeSpecifier => [
		size = numberOfTimeEvents
		type = _boolean
	]) timeEventsVariable(int numberOfTimeEvents) {
		documentation("Array to hold all time events")
		_private
		const = false
		static = true
		initialValue = numberOfTimeEvents._value
		generateDeclarationWith[ variableDeclarationCode ]	
	}
}
