package com.itemis.create.base.generator.core.concepts

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.concepts.TimerService
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Part
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory

@Singleton
class VirtualTimer {
	
	@Inject protected extension TimerService
	
	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	
	def create vt : createComplexType createVirtualTimer(){
		vt.name = virtualTimerName
		vt.superTypes += createTypeSpecifier => [
			type = createVirtualTimerInterface
		]
		vt.features += _op(timeLeap, _void)
		vt.features += _op(cycleLeap, _void)
		vt.features += _op(schedulePeriodicalTask, _void)
		val cTET = _complexType(cycleTimeEventTask) => [ c |
			c.features += _op(run, _void)
		]
		vt.features += cTET
		vt.features += _part(cycleTimeEventTask, cTET)
	}
	
	def virtualTimerName() { "VirtualTimer" }
	def timeLeap() { "TimeLeap" }
	def cycleLeap() { "CycleLeap" }
	def cycleTimeEventTask() { "CycleTimeEventTask" }
	def run() { "Run" }
	def schedulePeriodicalTask() { "SchedulePeriodicalTask" }
	
	def dispatch cycleTimeEventTaskPart(ComplexType it){
		features.filter(Part).filter[p | p.type.name === cycleTimeEventTask].head
	}
	
	def dispatch Operation schedulePeriodicalTaskOp(ComplexType it){
		features.filter(Operation).filter[name === schedulePeriodicalTask].head
	}
	
	def dispatch cycleLeapOp(ComplexType it){
		features.filter[name === cycleLeap].head
	}
	
	def dispatch timeLeapOp(ComplexType it){
		features.filter[name === timeLeap].head
	}
	
	def dispatch cycleTimeEventTaskPart(Type it){}
	
	def dispatch schedulePeriodicalTaskOp(Type it){}
	
	def dispatch cycleLeapOp(Type it){}
	
	def dispatch timeLeapOp(Type it){}
	
	def virtualTimerType() {
		_createCache_createVirtualTimer.get(#[])
	}
	
	def virtualTimerVar() {
		_createCache_createVirtualTimerVar.get(#[])
	}
	
	def create vt : _part("timer", virtualTimerType) createVirtualTimerVar(){}
}
