/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.IntLiteral
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.expressions.expressions.NullLiteral
import com.yakindu.base.expressions.expressions.StringLiteral
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.sct.generator.c.CMultiStatemachine
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.c.types.PlatformTypeMapping
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseExpressionExtensions
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import com.yakindu.sctunit.sCTUnit.CodeBlock
import com.yakindu.sctunit.sCTUnit.EnterExpression
import com.yakindu.sctunit.sCTUnit.ExitExpression
import com.yakindu.sctunit.sCTUnit.ExpressionStatement
import com.yakindu.sctunit.sCTUnit.ProceedExpression
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.StatechartActiveExpression
import com.yakindu.sctunit.sCTUnit.StatechartFinalExpression
import com.yakindu.sctunit.sCTUnit.TriggerWithoutEventExpression
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2

/**
 * 
 * @author Markus Muehlbrandt - Initial contribution and API
 * 
 */
class CExpressionsExtensions extends BaseExpressionExtensions {

	@Inject extension SCTUnitCNaming
	@Inject extension OriginTracing
	@Inject extension CMultiStatemachine
	@Inject extension ExpressionExtensions

	@Inject protected extension BaseNavigationExtensions
	@Inject protected extension ITypeSystemInferrer

	@Inject protected extension PlatformTypeMapping
	@Inject protected extension Literals
	@Inject protected extension StatemachineTypes

	@Inject(optional=true) ExecutionFlow flow

	override proceedCycles(ProceedExpression it) {
		'''sc_unit_timer_service_proceed_cycles(tc->timer_service, «value.code»);'''
	}

	override proceedTime(ProceedExpression it) {
		// implemented in each Domain Extension
		var time_ms = value.toMilliseconds(unit)
		'''sc_unit_timer_service_proceed_time(tc->timer_service, «time_ms.code»);'''
	}

	def dispatch CharSequence code(EventValueReferenceExpression it) {
		val value = value
		if (value instanceof FeatureCall) {
			return '''«value.owner.valueOfGetter(value.feature as EventDefinition)»'''
		}
		'''«eventDefinition.valueGetter»'''
	}

	override dispatch CharSequence code(EventRaisingExpression it) {
		val event = event
		if (event instanceof FeatureCall) {
			if (event.eContainer instanceof ComplexType) {
				return '''«event.owner.valueSetter(event.feature as EventDefinition)»'''
			}
			if (event.featureOrReference.eContainer instanceof ComplexType) {
				return '''«eventDefinition.asRaiser»(«getHandle(event.owner)»«IF value !== null», «value.code»«ENDIF»)'''
			}
		}
		return '''«eventDefinition.asRaiser»(&«statechartNaming»«IF value !== null», «value.code»«ENDIF»)'''
	}

	override dispatch CharSequence code(ActiveStateReferenceExpression it) {
		'''«naming.isStateActiveFctID(flow)»(&«statechartNaming», «naming.stateName(value)»)'''
	}

	override generateNotLocalAssignment(AssignmentExpression it) {
		if (varRef.isMultiSM) {
			val fc = varRef as FeatureCall
			return '''«fc.owner.valueSetter(fc.feature as Declaration, expression.code)»'''
		} else if (varRef.isComplexType) {
			val fc = varRef as FeatureCall
			val index = indexOfAssignmentExpression
			return '''
			«varRef.getComplexType.targetLanguageName» value«index» = «fc.toCallStack.head.valueGetter»;
			value«index».«fc.fqName» «operator.toString» «expression.code»;
			«fc.owner.valueSetter»(&«statechartNaming», value«index»)'''
		}
		return '''«varRef.valueSetter»(&«statechartNaming»,«expression.code»)'''
	}
	
	def fqName (FeatureCall it){
		toCallStack.map[it | if(it instanceof FeatureCall) {it.feature}].filter(NamedElement).join(".", [name])
	}
	
	def protected getIndexOfAssignmentExpression(AssignmentExpression it){
		val container = EcoreUtil2.getContainerOfType(it, CodeBlock)
		var assignments = container.code.filter(ExpressionStatement).map[expression].filter(AssignmentExpression).toList
		return assignments.indexOf(it)
	}

	override generateExternalAssignment(AssignmentExpression it) {
		'''«varRef.code» «operator.toString» «expression.code»'''
	}

	def dispatch TypeSpecifier getComplexType(Expression it) {
		return null
	}

	def dispatch TypeSpecifier getComplexType(FeatureCall it) {
		if (owner instanceof FeatureCall) {
			return owner.getComplexType
		}
		if (property !== null) {
			if ((owner as ElementReferenceExpression).reference instanceof VariableDefinition) {
				val vd = ((owner as ElementReferenceExpression).reference as VariableDefinition)
				return vd.typeSpecifier
			}
		}
	}

	def getProperty(FeatureCall it) {
		if(feature instanceof Property) return feature as Property
		return null
	}

	def dispatch boolean isComplexType(Expression it) {
		return false
	}

	def dispatch boolean isComplexType(FeatureCall it) {
		return getComplexType !== null
	}

	def dispatch boolean isMultiSM(FeatureCall it) {
		val container = feature.eContainer
		if (!feature.originTraces.nullOrEmpty) {
			return true
		}
		if (container instanceof ComplexType) {
			return container.statemachineType !== null
		}
		false
	}

	def dispatch boolean isMultiSM(Expression it) {
		false
	}

	override generateNotLocalElemRefExpr(ElementReferenceExpression it) {
		return '''«reference.getterName»(&«statechartNaming»)'''
	}

	override dispatch CharSequence code(LogicalRelationExpression it) {
		code(leftOperand.infer.type.platformType)
	}

	def dispatch CharSequence code(LogicalRelationExpression it,
		CTypes.CString pType) '''(strcmp(«leftOperand.code», «rightOperand.code») «operator.literal» 0)'''

	def dispatch CharSequence code(LogicalRelationExpression it,
		Object pType) '''(«leftOperand.code») «operator.literal» («rightOperand.code»)'''

	override dispatch CharSequence code(StatechartActiveExpression exp) {
		'''«exp.SCTUnitClass?.statechart.prefix»_is_active(&«statechartNaming»)''' // TODO: Naming of SCT-C Generator should be used for name
	}

	override dispatch CharSequence code(StatechartFinalExpression exp) {
		'''«exp.SCTUnitClass?.statechart.prefix»_is_final(&«statechartNaming»)''' // TODO: Naming of SCT-C Generator should be used for name
	}

	override dispatch code(Expression owner, EObject feature) {
		'''
			/*TODO -  unknown FeatureCall in «owner.eClass.name»
			* feature : «feature.eClass.name»
			*/
		'''
	}

	def dispatch code(Expression owner, Operation feature) {
		'''«feature.getFunctionId(owner.featureOrReference)»(«owner.valueGetter(feature)»«owner.args»)'''
	}

	override dispatch code(ElementReferenceExpression owner, Operation feature) {
		'''«feature.getFunctionId(owner.featureOrReference)»(«owner.valueGetter(feature)»«owner.args»)'''
	}

	protected def CharSequence args(
		Expression owner) '''«FOR arg : (owner.eContainer as FeatureCall).expressions BEFORE ', ' SEPARATOR ', '»«arg.code»«ENDFOR»'''

	def dispatch code(Expression owner, EventDefinition feature) {
		if (feature.eContainer instanceof ComplexType) {
			return '''«owner.valueGetter(feature)»'''
		}
		return '''«feature.asRaised»(&«statechartNaming»)'''
	}

	def dispatch code(Expression owner, VariableDefinition feature) {
		if (feature.eContainer instanceof ComplexType) {
			return '''«owner.valueGetter(feature)»'''
		}
		'''«feature.valueGetter»'''
	}

	def dispatch code(Expression owner, Enumerator feature) {
		if (!feature.eContainer.originTraces.nullOrEmpty) {
			return '''«naming.stateEnumAccess(feature)»'''
		}
		'''«feature.type.namespaceAccess»«feature.code»'''
	}

	def protected namespaceAccess(Type it) {
		// ComplexTypes and Packages are both Declarations
		return EcoreUtil2.getAllContainers(it).filter(Declaration).filter[!isTopLevelPackage].toList.reverse.join("",
			"::", "::", [name])
	}

	def protected isTopLevelPackage(EObject it) {
		return eContainer === null
	}

	def dispatch code(Expression owner, Property feature) {
		'''«owner.code».«feature.code»'''
	}

	def dispatch CharSequence code(NamedElement it) {
		'''«name»'''
	}

	def dispatch CharSequence code(EnterExpression it) {
		'''«naming.enterFctID(flow)»(&«statechartNaming»)'''
	}
	
	def dispatch CharSequence code(TriggerWithoutEventExpression it) {
		'''«naming.triggerWithoutEventFctID(flow)»(&«statechartNaming»)'''
	}

	def dispatch CharSequence code(ExitExpression it) {
		'''«naming.exitFctID(flow)»(&«statechartNaming»)'''
	}

	override dispatch CharSequence code(ElementReferenceExpression it) {
		if (reference instanceof SCTUnitOperation) {
			'''tc->«super._code(it)»'''.toString
		} else {
			super._code(it)
		}
	}

	override dispatch code(IntLiteral literal) '''«literal.value»'''

	override dispatch code(StringLiteral it) '''(sc_string)«super._code(it)»'''

	override dispatch CharSequence code(NullLiteral expression) '''«NULL_LITERAL»'''

}
