/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Thomas Kutz - itemis AG
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.sct.generator.c.CMultiStatemachine
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.AbstractSubchartInitializer
import java.util.HashMap
import java.util.Iterator
import java.util.Stack

/**
 * @author Robin Herrmann - initial API and contribution
 * @author Axel Terfloth
 */
class CSubchartInitializer extends AbstractSubchartInitializer {

	@Inject extension CMultiStatemachine
	@Inject extension Naming
	@Inject extension SCTUnitCNaming

	var String subchartMemberVariables = null

	var setSubmachine = ""
	var initSubmachine = ""
	var createSubmachines = ""
	var HashMap<Statechart, String> submachineMap = null
	var instanceIndex = 0

	override buildInitSequence(Statechart subchart, VariableDefinition element) {
		subchartMemberVariables += '''
			«subchart.name.toFirstUpper»* «element.instance»;
		''' 
		
		createSubmachines += '''
			«element.instance» = new «subchart.name.toFirstUpper»();
		'''

		initSubmachine += '''
			«getFunctionId("init", element.type)»(«element.instance»);
		'''
		
		setSubmachine += '''
			«element.asSetter»(«getFirstChain», «element.instance»);
		'''

		submachineMap.put(subchart, chain)
		initSequence = createSubmachines + initSubmachine + setSubmachine
	}
	
	override buildTeardownSequence(Statechart subchart, VariableDefinition element) {
		val freeElement = '''
			delete «element.instance»;
		'''
		teardownSequence = freeElement + teardownSequence;
		instanceIndex++
	}
	
	override synchronized perform(Object root) {
		submachineMap = newHashMap
		subchartMemberVariables = ""
		super.perform(root)
	}

	def getSubmachineMap(Statechart it) {
		submachineMap ?: {
			perform
			submachineMap
		}
	}
	
	def getSubchartMemberVariables(Statechart it) {
		subchartMemberVariables ?: {
			perform
			subchartMemberVariables
		}
	}

	private def String instance(VariableDefinition it) {
		'''«name.toFirstLower»_«instanceIndex»'''
	}
	
	private def String getChain() {
		if (variableStack.length > 0) {
			val stack = (variableStack.clone as Stack<VariableDefinition>).reverse
			return stack.listIterator.join("", "(", terminatedHandle(stack.length - 1), [asGetter])
		}
		'''«terminatedHandle(0)»'''
	}

	private def String getFirstChain() {
		if (variableStack.length > 1) {
			val stack = (variableStack.clone as Stack<VariableDefinition>).reverse
			return stack.skipFirstIterator.join("", "(", terminatedHandle(stack.length - 2), [asGetter])
		}
		'''«terminatedHandle(0)»'''
	}
	
	private def <T> Iterator<T> skipFirstIterator(Iterable<T> iterable) {
		val iterator = iterable.iterator
		iterator.next
		iterator
	}

	private def terminatedHandle(int length) {
		'''(&«statechartNaming»«FOR l : (0..length)»)«ENDFOR»'''
	}
	
}
