/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	René Beckmann - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sctunit.generator.c.CSCTUnitFileSystemAccessFactory
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import org.eclipse.xtext.generator.IFileSystemAccess

/**
 * 
 * @author René Beckmann - Initial contribution and API
 * 
 */

class TimerServiceHeader extends GTest {

	@Inject
	protected GeneratorEntry entry
	@Inject extension SCTUnitCNaming
	@Inject extension FileNaming
	
	def generateTimerServiceHeader(SCTUnitClass it, IFileSystemAccess fsa, String outletFolder) {
		var content = generateTimerServiceHeader
		fsa.generateFile(sc_timer_service.h, CSCTUnitFileSystemAccessFactory.LIBRARY_TARGET_FOLDER_OUTPUT, content)
	}

	def private generateTimerServiceHeader(SCTUnitClass it) {
		'''
			/*
			 * Timer Service for SCTUnit
			 */
			
			#ifndef SC_UNIT_TIMER_SERVICE_H_
			#define SC_UNIT_TIMER_SERVICE_H_
			
			#include "«typesModule.h»"
			
			#ifdef __cplusplus
			extern "C" {
			#endif
			
			/*! file/ Interface definition of a POSIX thread based timer service for itemis CREATE state machines. */
			
			typedef struct {
				«sc_time.fqName» rel_time_ms;
				«sc_time.fqName» abs_time_ms;
				sc_boolean periodic;
				sc_eventid pt_evid;
				sc_integer priority;
				sc_boolean isRunCycle;
				void* handle;
			} sc_unit_timer_t;
			
			typedef struct sc_unit_timer_task_s {
				sc_unit_timer_t timer;
				struct sc_unit_timer_task_s * next;
			} sc_unit_timer_task_t;
			
			/*! Function pointer type for state machines raiseEvent function. */
			typedef void (*sc_raise_time_event_fp)(void *handle, sc_eventid evid);
			typedef void (*sc_run_cycle_fp)(void *handle);
			
			typedef struct {
				sc_unit_timer_task_t * tasks;
				sc_raise_time_event_fp raise_event_func;
				sc_run_cycle_fp run_cycle_func;
				sc_boolean event_driven;
				sc_integer cycle_period;
				void* handle;
				«sc_time.fqName» current_time_ms;
			
			} sc_unit_timer_service_t;
			
			void sc_unit_timer_service_init(
				sc_unit_timer_service_t * ts,
				sc_raise_time_event_fp raise_event_func,
				sc_run_cycle_fp run_cycle_func,
				sc_boolean event_driven,
				sc_integer cycle_period,
				void* handle
			);
			
			void sc_unit_timer_init(
				sc_unit_timer_t * t,
				«sc_time.fqName» time_ms,
				sc_boolean periodic,
				sc_eventid evid,
				void* handle
			);
			
			void sc_unit_timer_service_free(
				sc_unit_timer_service_t * t
			);
			
			void sc_unit_timer_service_proceed_time(sc_unit_timer_service_t * ts, sc_integer time_ms);
			void sc_unit_timer_service_proceed_cycles(sc_unit_timer_service_t * ts, sc_integer cycles);
			sc_unit_timer_t sc_unit_timer_service_proceed(sc_unit_timer_service_t * ts);
			
			void insert_timer(sc_unit_timer_service_t * ts, sc_unit_timer_t te);
			
			void delete_task(sc_unit_timer_service_t * ts, sc_unit_timer_task_t* task);
			
			sc_unit_timer_task_t * find_time_event(sc_unit_timer_service_t * ts, sc_eventid evid);
			
			sc_unit_timer_task_t * pop_task(sc_unit_timer_service_t * ts);
			
			«sc_time.fqName» compare(sc_unit_timer_t * a, sc_unit_timer_t * b);
			
			#ifdef __cplusplus
			}
			#endif
			
			#endif /* SC_UNIT_TIMER_SERVICE_H_ */
			
		'''
	}
}
