/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python

import com.google.inject.Inject
import com.yakindu.sct.generator.core.templates.SexecGenerator
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.Call
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.CheckRef
import com.yakindu.sct.model.sexec.DoWhile
import com.yakindu.sct.model.sexec.EnterState
import com.yakindu.sct.model.sexec.Execution
import com.yakindu.sct.model.sexec.ExitState
import com.yakindu.sct.model.sexec.HistoryEntry
import com.yakindu.sct.model.sexec.If
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.SaveHistory
import com.yakindu.sct.model.sexec.ScheduleTimeEvent
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.StateSwitch
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.UnscheduleTimeEvent
import com.yakindu.sct.model.sexec.concepts.MicroStep
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgraph.util.SgraphExtensions
import java.util.List
import org.eclipse.xtext.EcoreUtil2

class FlowCode extends SexecGenerator {

	@Inject extension Naming
	@Inject extension INamingService
	@Inject extension PythonExpressionsGenerator
	@Inject extension MicroStep
	@Inject extension SgraphExtensions

	var List<TimeEvent> timeEvents;

	override stepComment(Step it) '''
		«IF !comment.nullOrEmpty»
			#«comment»
		«ENDIF»
	'''

	def dispatch CharSequence code(Step it) ''''''
	
	def dispatch CharSequence code(DoWhile it) {
	'''
		«stepComment»
		«condition» = True
		while «condition»:
			«body.code»
			«condition» = «check.code»
	'''
	}
	
	def private condition(DoWhile it) {
		'''condition_«EcoreUtil2.getContainerOfType(it, Method).eAllContents.filter(DoWhile).toList.indexOf(it)»'''
	}

	def dispatch CharSequence code(StateSwitch it) '''
		«IF historyRegion !== null»
			state = self.«historyVector»[«historyRegion.historyVector.offset»]
		«ELSE»
			state = self.«stateVector»[«stateConfigurationIdx»]
		«ENDIF»
		«FOR stateCase : cases»
			«IF stateCase == cases.get(0)»
				if state == self.State.«stateCase.state.stateName.asEscapedIdentifier»:
					«IF stateCase.step !== null»«stateCase.step.code»«ELSE»pass«ENDIF»
			«ELSE»
				elif state == self.State.«stateCase.state.stateName.asEscapedIdentifier»:
					«IF stateCase.step !== null»«stateCase.step.code»«ELSE»pass«ENDIF»
			«ENDIF»
		«ENDFOR»
	'''
	
	def dispatch CharSequence code(ScheduleTimeEvent it) '''
	«stepComment»
	self.timer_service.set_timer(self, «getTimeEvents.indexOf(timeEvent)», «timeValue.code», «IF timeEvent.periodic»True«ELSE»False«ENDIF»)'''
	
	def dispatch CharSequence code(UnscheduleTimeEvent it) '''
	«stepComment»
	self.timer_service.unset_timer(self, «getTimeEvents.indexOf(timeEvent)»)'''


	override dispatch CharSequence code(Execution it) '''
	«statement.code»'''

	def dispatch CharSequence code(Call it) '''
	self.__«step.functionName()»()'''


	def dispatch CharSequence code(Check it) '''
		«condition.code()»'''

	def dispatch CharSequence code(CheckRef it) '''
		«IF check !== null»self.__«check.functionName()»()«ELSE»True«ENDIF»
	'''


	def dispatch CharSequence code(If it) {
	// avoid empty then blocks
	if(thenStep instanceof Sequence){
		if((thenStep as Sequence).steps.isEmpty){
			return ''''''
		}
	}
	'''
			«stepComment»
			if «IF it instanceof Check»self.«ENDIF»«check.code.toString.trim»:
				«thenStep.code»
			«IF elseStep !== null && elseStep.code.length != 0»
				«IF elseStep instanceof If»el«elseStep.code»«ELSE»
					else:
						«elseStep.code»
				«ENDIF»
			«ENDIF»
		'''}

	def dispatch CharSequence code(EnterState it) {
		val firstPos = state.statevectorFirstPosition
		val lastPos = state.statevectorLastPosition
		'''
			«stepComment»
			«FOR i: firstPos .. lastPos»
				self.«stateVector»[«i»] = self.State.«state.stateName.asEscapedIdentifier»
			«ENDFOR»
			«IF flow.needsStateVectorPosition»
				self.«flow.stateVectorPosition.identifier» = «firstPos»
			«ENDIF»		
			self.__state_conf_vector_changed = True
		'''
	}

	def dispatch CharSequence code(ExitState it) {
		val parentState = it.state.sourceElement.parentState
		val stateName = if ( parentState !== null ) parentState.stateName else nullStateName
		val firstPos = state.statevectorFirstPosition
		val lastPos = state.statevectorLastPosition
		'''
			«stepComment»
			«FOR i: firstPos .. lastPos»
				self.«stateVector»[«i»] = self.State.«stateName»
			«ENDFOR»
			«IF flow.needsStateVectorPosition»
				self.«flow.stateVectorPosition.identifier» = «lastPos»
			«ENDIF»
		'''	
	}

	def dispatch CharSequence code(HistoryEntry it) '''
		«stepComment»
		if self.«historyVector»[«region.historyVector.offset»] is not self.State.«nullStateName»:
			«historyStep.code»
		«IF initialStep !== null»else:
			«initialStep.code»
		«ENDIF»
	'''

	def dispatch CharSequence code(SaveHistory it) '''
		«stepComment»
		self.«historyVector»[«region.historyVector.offset»] = self.«stateVector»[«region.stateVector.offset»]
	'''

	def private getTimeEvents(Step it) {
		if (timeEvents === null) {
			timeEvents = flow.timeEvents
		}
		return timeEvents
	}
	
	override dispatch CharSequence code(LocalVariableDefinition it) '''
		«variable.name»«IF initialValue !== null» = «initialValue.code»«ENDIF»
	'''
	
}
