/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.python

import com.google.inject.Inject
import com.yakindu.base.types.Property
import com.yakindu.base.types.Type
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.concepts.EventBuffer

/**
 * @author Robin Herrmann
 */
class InitialValueProvider {
	
	@Inject extension EventBuffer
	@Inject extension ICodegenTypeSystemAccess
		
	def dispatch initialValue(Void it, Type type){
		if(type.isEventBuffer) {
			return '''
			self.«type.targetLanguageName»(
				«FOR property : type.features.filter(Property) SEPARATOR ", "»
					self.«property.type.targetLanguageName»()
				«ENDFOR»
			)'''
		}
		'''None'''
	}
	
	def dispatch initialValue(Object it, Type type){
		'''None'''
	}
	
	def dispatch initialValue(Boolean it, Type type){
		'''False'''
	}
}
