/**
* Copyright (c) 2020 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*/
package com.yakindu.sct.generator.python

import com.google.common.collect.Sets
import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.EnumerationType
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.util.StatechartUtil

/**
 * 
 * @author Robin Herrmann
 */
class PythonStatechartIncludeProvider extends PythonIncludeProvider {
	
	@Inject extension StatechartUtil
	@Inject extension Naming
	@Inject extension GenmodelEntries
	@Inject extension StringHelper

	override Iterable<String> getImports(ExecutionFlow it, GeneratorEntry entry) {
		val imports = Sets.newHashSet
		val neededStatecharts = getIsStateActiveFeatureCalls.map[feature.getOriginStatechart()].toSet
		for (neededStatechart : neededStatecharts) {
			imports.add('''from «entry.getBasePackage(neededStatechart).dot(neededStatechart.statemachineClassName)» import «neededStatechart.statemachineName»''')
		}
		return imports
	}
	
	def protected getIsStateActiveFeatureCalls(ExecutionFlow it) {
		it.eAllContents.filter(FeatureCall).filter[feature instanceof EnumerationType && feature.isMultiSM]
	}
}
