/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.python.eventdriven

import com.yakindu.sct.generator.python.submodules.EventCode
import com.google.inject.Singleton
import com.yakindu.sct.model.sexec.ExecutionFlow

/**
 * @author Robin Herrmann
 */
@Singleton
class EventDrivenEventCode extends EventCode {

	override eventNextCode(ExecutionFlow flow) '''
		next_event = self.__get_next_event()
		if next_event is not None:
			self.__execute_queued_event(next_event)
	'''
	
	override getNextEventCode(ExecutionFlow flow) {
		'''
		False
		next_event = self.__get_next_event()
		if next_event is not None:
			self.__execute_queued_event(next_event)
			condition_0 = True
	'''
	}
	
}
