/*
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
package com.yakindu.sct.generator.python.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.generator.python.submodules.ScopeGenerator
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.stext.stext.EventDefinition

class EventDrivenScopeGenerator extends ScopeGenerator {

	@Inject protected extension EventQueue
	
	@Inject extension Naming
	@Inject extension SExecExtensions
	
	override protected inEventMethod(EventDefinition it) {
		if (flow.requiresIncomingEventQueue) {
			if (hasValue)
			'''
				def «raiseFunctionName»(self, value):
					"""Raise method for event «identifier».
					"""
					self.«statemachine»in_event_queue.put(lambda: self.«raiseCallFunctionName»(value))
					self.«statemachine»run_cycle()
				
				def «raiseCallFunctionName»(self, value):
					"""Raise callback for event «identifier».
					"""
					self.«identifier» = True
					self.«valueIdentifier» = value
				
			'''		
			else
			'''
				def «raiseFunctionName»(self):
					"""Raise method for event «identifier».
					"""
					self.«statemachine»in_event_queue.put(self.«raiseCallFunctionName»)
					self.«statemachine»run_cycle()
				
				def «raiseCallFunctionName»(self):
					"""Raise callback for event «identifier».
					"""
					self.«identifier» = True
				
			'''		
		}
		else {
			if (hasValue)
			'''
				def «raiseFunctionName»(self, value):
					"""Raise method for event «identifier».
					"""
					self.«identifier» = True
					self.«valueIdentifier» = value
					self.«statemachine»run_cycle()
				
			'''
			else
			'''
				def «raiseFunctionName»(self):
					"""Raise method for event «identifier».
					"""
					self.«identifier» = True
					self.«statemachine»run_cycle()
				
			'''
		}
	}
	
	override protected localEventMethod(EventDefinition it) {
		if (flow.requiresInternalEventQueue) {
			if (hasValue)
			'''
				def «raiseFunctionName»(self, value):
					"""Raise method for event «identifier».
					"""
					self.__internal_event_queue.put(lambda: self.«raiseCallFunctionName»(value))
				
				def «raiseCallFunctionName»(self, value):
					"""Raise callback for event «identifier».
					"""
					self.«identifier» = True
					self.«valueIdentifier» = value
				
			'''		
			else
			'''
				def «raiseFunctionName»(self):
					"""Raise method for event «identifier».
					"""
					self.__internal_event_queue.put(self.«raiseCallFunctionName»)
				
				def «raiseCallFunctionName»(self):
					"""Raise callback for event «identifier».
					"""
					self.«identifier» = True
				
			'''		
		}
		else {
			if (hasValue)
			'''
				def «raiseFunctionName»(self, value):
					"""Raise method for event «identifier».
					"""
					self.«identifier» = True
					self.«valueIdentifier» = value
				
			'''
			else
			'''
				def «raiseFunctionName»(self):
					"""Raise method for event «identifier».
					"""
					self.«identifier» = True
				
			'''
		}
	}

}