/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess
import com.yakindu.sct.generator.python.files.Statemachine
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

class EventDrivenStatemachine extends Statemachine {
	
	@Inject protected extension EventQueue
	
	override protected imports(ExecutionFlow flow, ISCTFileSystemAccess fsa) {
		'''
		«IF flow.requiresEventQueue»
		import queue
		«ENDIF»
		«super.imports(flow, fsa)»
		'''
	}
	
	protected override internalScopeMembers(ExecutionFlow flow)
		'''
		«IF flow.requiresInternalEventQueue»
		self.__internal_event_queue = queue.Queue()
		«ENDIF»
		«IF flow.requiresIncomingEventQueue»
		self.in_event_queue = queue.Queue()
		«ENDIF»
		«super.internalScopeMembers(flow)»
		'''
		
	override protected internalScopeFunctions(ExecutionFlow flow) {
		if (!flow.requiresEventQueue) {
			super.internalScopeFunctions(flow)
		} else {
			'''
			def __execute_queued_event(self, func):
				func()
			
			def __get_next_event(self):
				«IF flow.requiresInternalEventQueue»
				if not self.__internal_event_queue.empty():
					return self.__internal_event_queue.get()
				«ENDIF»
				«IF flow.requiresIncomingEventQueue»
				if not self.in_event_queue.empty():
					return self.in_event_queue.get()
				«ENDIF»
				return None
			
			«super.internalScopeFunctions(flow)»
			'''
		}
	}
	
}