/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.generator.core.filesystem.OutputConfigProvider
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.python.GenmodelEntries
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

class RuntimeService {
	
	// TODO: Implement Runtime Service! This feature is temporary not available.
	
	@Inject extension Naming
	@Inject extension StringHelper
	@Inject extension GenmodelEntries
	@Inject extension PackageInit
	@Inject extension ICoreLibraryHelper
	@Inject extension OutputConfigProvider
	
	def generateRuntimeService(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa) {
		if (entry.skipLibraryFiles) {
			return
		}
		val path = entry.libraryPackage.toPath
		fsa.generateFile(path + '/' + runtimeServiceClass.py, entry.libraryOutputConfig, content(entry))
		if (!path.nullOrEmpty)
			fsa.generatePyPackageInit(path, entry.libraryOutputConfig, entry)
	}
	
	def private content(GeneratorEntry entry) {
		'''
			"""«entry.licenseText»"""
			import sched
			import time  # time in sec represented as floating point number -> 100ms = 0.1s
			import threading
			
			class RuntimeService(object):
			
				"""
				
				Runtime service for state machines to execute a run to completion step
				periodically.
				
				"""
			
				def __init__(self):
				
				#private static RuntimeService runtimeService;
				self.scheduler = sched.scheduler(time.time, time.sleep)
				# <Long,StatemachineTimerTask>
				self.timer_tasks_dict = {}
			
				class StatemachineTimerTask(object):
			
				def __init__(self):
					
					self.statemachine_list = []
					self.rlock = threading.RLock()
					self.is_paused = False
			
					def run(self):
						# readLock
						self.rlock.acquire()
						if not isPaused:
							for statemachine in statemachine_list:
								statemachine.run_cycle()
						self.rlock.release()
			
					def add_statemachine(self, statemachine):
						"""
						Adds the given state machine to the TimerTask.
						Keyword Argument:
						[IStatemachine] statemachine
						"""
						# writeLock
						self.rlock.acquire()
						ret = False
						try:
							statemachine_list.append(statemachine)
							ret = True
						except (ValueError, NameError):
							print('Statemachine cant be added. Check variable definition.')
						self.rlock.release()
						return ret
			
					def remove_statemachine(self, statemachine):
						"""
						Removes the given state machine from the TimerTask.
						Keyword Argument:
						[IStatemachine] statemachine
						Return:
						True if state machine is removed properly.
						"""
						# writeLock
						self.rlock.acquire()
						ret = False
						try:
							statemachine_list.remove(statemachine)
							ret == True
						except ValueError:
							print('Statemachine to remove not found')
						self.rlock.release()
						return ret
			
					def pause(self):
						self.is_paused = True
			
					def resume(self) {
						self.is_paused = False
			
			
				def register_statemachine(self, statemachine, cycle_period):
					"""
					Registers an {@link IStatemachine} for scheduled fixed rate execution.
					
					Keyword Arguments:
					[IStatemachine] statemachine - The state machine to execute
					[long] cycle_period - the fixed rate cycle period for scheduling
					
					Return:
					True if state machine is added properly.
					"""
			
					if cycle_period in self.timerTasks:
						// TimerTask for cycle time already existing -> add state machine
						return self.timer_tasks_dict[cycle_period].add_statemachine(statemachine)
					} else {
						// Create new TimerTask for cycle period and add state machine
						timer_task = self.StatemachineTimerTask()
						timer_tasks_dict[cycle_period] = timer_task
						ret = timer_task.add_statemachine(statemachine)
						// Create a new Timer instance if runtime service was cancelled
						// before
						if (timer == null) {
							timer = new Timer();
						}
						timer.scheduleAtFixedRate(timerTask, 0, cyclePeriod);
						return ret;
					}
				}
			
				def unregister_statemachine(self, statemachine, cycle_period):
				"""
				Removes the given state machine from runtime service.
				
				Keyword Arguments:
				[IStatemachine] statemachine - the state machine to be removed.
				[long] cyclePeriod - the scheduling cycle period of the state machine.
				
				Return:
				True if state machine is removed properly.
				"""
				if (timerTasks.containsKey(cyclePeriod)) {
					boolean ret = timerTasks.get(cyclePeriod).removeStatemachine(
							statemachine);
			
						return ret;
					}
					return false;
				}
			
				def cancel_all(self, cycle_period):
				"""
				Cancels the execution of state machines for the given cycle period. This
				stops the execution of state machines which are registered for the given
				cycle period and cancels the executing {@link TimerTask}.
				
				Keyword Argument:
				[long] cyclePeriod
				
				Return:
				True if poperly cancelled.
				"""
				if (timer != null && timerTasks.containsKey(cyclePeriod)) {
					TimerTask task = timerTasks.get(cyclePeriod);
					task.cancel();
					timer.purge();
					timerTasks.remove(cyclePeriod);
					return true;
				}
				return false;
				}
			
				def pause_all(self, cycle_period):
				"""
				Pauses the execution of all state machines which are registered for the
				given cyclePeriod.
				
				Keyword Argument:
				[long] cyclePeriod
				
				Return:
				True if properly paused
				"""
				if (timerTasks.containsKey(cyclePeriod)) {
					timerTasks.get(cyclePeriod).pause();
					return true;
				}
				return false;
				}
			
				def resume_all(self, cycle_period):
				"""
				Resumes the execution of all state machines which are registered for the
				given cyclePeriod.
				
				Keyword Argument:
				[long] cyclePeriod
				
				Return:
				True if properly resumed.
				"""
				if (timerTasks.containsKey(cyclePeriod)) {
					timerTasks.get(cyclePeriod).resume();
					return true;
				}
				return false;
				}
			
				def cancel_timer(self):
				"""
				Cancels the execution of all registered state machines. This cancels the
				executing {@link Timer} freeing all allocated resources and terminates
				all existing execution threads.
				"""
				if not self.timer:
					self.timer.cancel();
					self.timer.purge();
					self.timerTasks.clear();
					self.timer = None
		'''
	}
}
