/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.python.library.impl

import static com.yakindu.base.types.typesystem.ITypeSystem.*
import com.yakindu.sct.generator.core.library.impl.CoreFeatureTypeLibraryProvider

class PythonFeatureTypeLibraryProvider extends CoreFeatureTypeLibraryProvider {

	def naming() {
		createFeatureType => [
			name = "Naming"
			optional = true
			parameters += createFeatureParameter => [
				name = "basePackage"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "libraryPackage"
				optional = true
				parameterType = getType(STRING)
			]
		]
	}

	def generalFeatures() {
		createFeatureType => [
			name = "GeneralFeatures"
			optional = true
			parameters += createFeatureParameter => [
				name = "DefaultTimer"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "RuntimeTemplate"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def pyPacking() {
		createFeatureType => [
			name = "PyPackaging"
			optional = true
			parameters += createFeatureParameter => [
				name = "CreateFiles"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "Author"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "Version"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "ShortDescription"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "License"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "URL"
				optional = true
				parameterType = getType(STRING)
			]
		]
	}

	override provide() {
		create([super.provide]) => [
			name = "Python Generator"
			types += naming()
			types += generalFeatures()
			types += pyPacking()
		]
	}
}
