/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sct.generator.python.submodules

import com.google.inject.Inject
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

/**
 * @author Robin Herrmann
 */
class InitializedCheckCode implements com.yakindu.sct.generator.core.submodules.lifecycle.InitializedCheckCode {
	
	@Inject extension SExecExtensions
	@Inject extension Naming

	override initializedCheckCode(ExecutionFlow flow) {
		'''
			«IF flow.timed»
				if self.timer_service is None:
					raise ValueError('Timer service must be set.')
				
			«ENDIF»
			«FOR internalScope : flow.internalScopes»
				«IF internalScope.hasOperations»
					if self.«internalScope.operationCallbackInstance» is None:
						raise ValueError("Internal operation callback must be set.")
					
				«ENDIF»
			«ENDFOR»
			«FOR scope : flow.namedInterfaceScopes»
				«IF scope.hasOperations»
					if self.«scope.interfaceVariableName».«scope.operationCallbackInstance» is None:
						raise ValueError("Operation callback for interface «scope.interfaceTypeName» must be set.")
					
				«ENDIF»
			«ENDFOR»
			«val defaultScope = flow.defaultScope»
			«IF defaultScope !== null && defaultScope.hasOperations»
				if self.«defaultScope.operationCallbackInstance» is None:
					raise ValueError("Operation callback must be set.")
				
			«ENDIF»
		'''
	}

}
