/**
* Copyright (c) 2020 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
*/
package com.yakindu.sct.generator.python.types

import com.google.inject.Inject
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sexec.concepts.EventBuffer

import static com.yakindu.base.types.typesystem.ITypeSystem.*

/**
 * @author andreas muelder
 */
class PythonTypeSystemAccess implements ICodegenTypeSystemAccess {

	@Inject protected extension ITypeSystem
	@Inject protected extension EventBuffer
	@Inject protected extension Naming
	
	override getTargetLanguageName(Type type) {
		val originalType = type?.originType
		switch (originalType) {
			case originalType === null || isSame(originalType, getType(VOID)) : 'void'
			case isSame(originalType, getType(INTEGER)): 'int'
			case isSame(originalType, getType(REAL)): 'float'
			case isSame(originalType, getType(BOOLEAN)): 'boolean'
			case isSame(originalType, getType(STRING)): 'str'
			case originalType.isEventBuffer: originalType.eventBufferTypeName
			default: throw new IllegalArgumentException("Target language name could not be inferred for type " + type)
		}
	}
	
	override getTargetLanguageName(TypeSpecifier typeSpecifier) {
		return getTargetLanguageName(typeSpecifier?.type)
	}

}
