/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sctunit.ui

import com.google.inject.Binder
import com.google.inject.name.Names
import com.yakindu.base.expressions.ui.highlighting.ExpressionsSemanticHighlightingCalculator
import com.yakindu.base.utils.jface.help.CrossRefObjectTextHover
import com.yakindu.base.utils.jface.help.HelpHoverProvider
import com.yakindu.base.utils.jface.help.HelpHoverProvider.OpenInHelpAction
import com.yakindu.sct.model.stext.terminals.STextValueConverterService
import com.yakindu.sct.model.stext.ui.document.TransactionalXtextDocument
import com.yakindu.sctunit.ui.help.SCTUnitUserHelpDocumentationProvider
import com.yakindu.sctunit.ui.highlighting.SCTUnitHighlightingConfiguration
import org.eclipse.ui.plugin.AbstractUIPlugin
import org.eclipse.xtext.conversion.IValueConverterService
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider
import org.eclipse.xtext.ui.editor.hover.DispatchingEObjectTextHover
import org.eclipse.xtext.ui.editor.hover.IEObjectHover
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider
import org.eclipse.xtext.ui.editor.model.XtextDocument
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator

@SuppressWarnings("deprecation")
class SCTUnitUiModule extends AbstractSCTUnitUiModule {
	
	new(AbstractUIPlugin plugin) {
		super(plugin)
	}

	def Class<? extends IHighlightingConfiguration> bindIHighlightingConfiguration() {
		return SCTUnitHighlightingConfiguration
	}

	def configureHelpAction(Binder binder) {
		binder.bind(String).annotatedWith(Names.named(OpenInHelpAction.CONTEXTID)).toInstance(
			"com.yakindu.sct.ui.editor.sctunit_keyword")
	}

	def Class<? extends XtextDocument> bindXtextDocument() {
		TransactionalXtextDocument
	}

	def configureDomainId(Binder binder) {
		binder.bind(String).annotatedWith(Names.named("domain.id")).toInstance("com.yakindu.sct.domain")
	}

	def Class<? extends IEObjectHoverProvider> bindIEObjectHoverProvider() {
		return HelpHoverProvider
	}

	def Class<? extends IEObjectDocumentationProvider> bindIEObjectDocumentationProvider() {
		return SCTUnitUserHelpDocumentationProvider
	}

	def Class<? extends DispatchingEObjectTextHover> bindDispatchingEObjectTextHover() {
		return CrossRefObjectTextHover
	}

	override Class<? extends IEObjectHover> bindIEObjectHover() {
		return CrossRefObjectTextHover
	}

	def Class<? extends IValueConverterService> bindIValueConverterService() {
		return STextValueConverterService
	}
	
	def Class<? extends ISemanticHighlightingCalculator> bindISemanticHighlightingCalculatorUI() {
		return ExpressionsSemanticHighlightingCalculator;
	}
	
}
