/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sctunit.ui.quickfix

import com.yakindu.sctunit.sCTUnit.EnterExpression
import com.yakindu.sctunit.sCTUnit.ExpressionStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitFactory
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.TestStatement
import com.yakindu.sctunit.validation.SCTUnitValidationMessages
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.jface.text.BadLocationException
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider
import org.eclipse.xtext.ui.editor.quickfix.Fix
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor
import org.eclipse.xtext.validation.Issue

/** 
 * @author bohl
 */
class SCTUnitQuickfixProvider extends DefaultQuickfixProvider {

	@Fix(SCTUnitValidationMessages.MISSING_ENTER_STAMEMENT)
	def void fixMissingEnterStatement(Issue issue, IssueResolutionAcceptor acceptor) {
		acceptor.accept(issue, "Missing enter statement", "Adds an 'enter' statement.", null, new EnterModification())
	}

	@Fix(SCTUnitValidationMessages.MISSING_ENTER_STAMEMENT_2)
	def void fixMissingEnterStatement2(Issue issue, IssueResolutionAcceptor acceptor) {
		acceptor.accept(issue, "Missing enter statement",
			"Adds an 'enter' statement in front of this 'cycle'-statement", null, new EnterModification2())
	}

	private static class EnterModification implements ISemanticModification {
		override void apply(EObject element, IModificationContext context) throws BadLocationException {
			var SCTUnitOperation operation = EcoreUtil2.getContainerOfType(element, SCTUnitOperation)
			var EnterExpression enterStatement = SCTUnitFactory.eINSTANCE.createEnterExpression()
			var ExpressionStatement expressionStatement = SCTUnitFactory.eINSTANCE.createExpressionStatement()
			expressionStatement.setExpression(enterStatement)
			operation.getBody().getCode().add(0, expressionStatement)
		}
	}

	private static class EnterModification2 implements ISemanticModification {
		override void apply(EObject element, IModificationContext context) throws BadLocationException {
			var SCTUnitOperation operation = EcoreUtil2.getContainerOfType(element, SCTUnitOperation)
			var EnterExpression enterStatement = SCTUnitFactory.eINSTANCE.createEnterExpression()
			var ExpressionStatement expressionStatement = SCTUnitFactory.eINSTANCE.createExpressionStatement()
			expressionStatement.setExpression(enterStatement)
			var List<TestStatement> contents = operation.getBody().getCode()
			var EObject element2 = element
			var boolean testCaseFound = false
			do {
				if (element2.eContainer().equals(operation)) {
					testCaseFound = true
				} else {
					element2 = element2.eContainer()
				}
			} while (testCaseFound === false)
			operation.getBody().getCode().add(contents.indexOf(element2), expressionStatement)
		}
	}
}
