/** 
 * Copyright (c) 2016 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sctunit

import com.google.inject.Binder
import com.google.inject.multibindings.Multibinder
import com.google.inject.name.Names
import com.yakindu.base.base.BasePackage
import com.yakindu.base.expressions.parser.SyntaxErrorMessageProvider
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.libraries.ITypeLibraryProvider
import com.yakindu.base.types.libraries.TypeLibraryRegistry
import com.yakindu.base.types.scoping.IPackageImport2URIMapper
import com.yakindu.base.types.scoping.PackageImport2URIMultiMapper
import com.yakindu.base.types.scoping.TypeLibraryImport2URIMapper
import com.yakindu.base.types.typesystem.GenericTypeSystem
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.domain.^extension.DomainRegistry
import com.yakindu.sct.model.stext.naming.StextNameProvider
import com.yakindu.sct.model.stext.scoping.ContextPredicateProvider
import com.yakindu.sct.model.stext.scoping.StextDefaultTypeLibraries
import com.yakindu.sct.model.stext.terminals.STextValueConverterService
import com.yakindu.sctunit.concepts.SCTUnitAnnotations
import com.yakindu.sctunit.formatting.SCTUnitFormatter
import com.yakindu.sctunit.inferrer.SCTUnitTypeInferrer
import com.yakindu.sctunit.resource.SCTUnitResourceDescriptionStrategy
import com.yakindu.sctunit.scoping.SCTUnitContextPredicateProvider
import com.yakindu.sctunit.scoping.SCTUnitDefaultTypeLibraries
import com.yakindu.sctunit.scoping.SCTUnitGlobalScopeProvider
import com.yakindu.sctunit.scoping.SCTUnitImportAwareScopeProvider
import org.eclipse.core.resources.IWorkspaceRoot
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.xtext.conversion.IValueConverterService
import org.eclipse.xtext.naming.IQualifiedNameProvider
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy
import org.eclipse.xtext.scoping.IGlobalScopeProvider
import org.eclipse.xtext.scoping.IScopeProvider
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider
import org.eclipse.xtext.validation.CompositeEValidator

class SCTUnitRuntimeModule extends AbstractSCTUnitRuntimeModule {

	def configureDomainID(Binder binder) {
		binder.bind(String).annotatedWith(Names.named(DomainRegistry.DOMAIN_ID)).toInstance(
			BasePackage.Literals.DOMAIN_ELEMENT__DOMAIN_ID.getDefaultValueLiteral())
	}

	def configureEObjectValidator(Binder binder) {
		binder.bind(boolean).annotatedWith(Names.named(CompositeEValidator.USE_EOBJECT_VALIDATOR)).toInstance(false)
	}
	
	def configureITypeSystem(Binder binder) {
		binder.bind(ITypeSystem).toInstance(GenericTypeSystem.getInstance())
	}

	def Class<? extends ITypeLibraryProvider> bindITypeLibraryProvider() {
		TypeLibraryRegistry
	}

	def void configureImport2URIMappers(Binder binder) {
		var setBinder = Multibinder.newSetBinder(binder,
						IPackageImport2URIMapper, Names.named(PackageImport2URIMultiMapper.MULTI_MAPPINGS));
		setBinder.permitDuplicates
		setBinder.addBinding().to(TypeLibraryImport2URIMapper);
	}

	def void configureTypeLibraryProviders(Binder binder) {
		TypeLibraryRegistry.bind(binder, SCTUnitAnnotations.Library.Provider)
	}

	def Class<? extends StextDefaultTypeLibraries> bindDefaultTypeLibraries() {
		SCTUnitDefaultTypeLibraries
	}

	def Class<? extends IDefaultResourceDescriptionStrategy> bindIDefaultResourceDescriptionStrategy() {
		SCTUnitResourceDescriptionStrategy
	}

	override Class<? extends IGlobalScopeProvider> bindIGlobalScopeProvider() {
		SCTUnitGlobalScopeProvider
	}

	override Class<? extends IQualifiedNameProvider> bindIQualifiedNameProvider() {
		StextNameProvider
	}

	def IWorkspaceRoot bindIWorkspaceRootToInstance() {
		ResourcesPlugin.getWorkspace().getRoot()
	}

	override Class<? extends IValueConverterService> bindIValueConverterService() {
		STextValueConverterService
	}

	def Class<? extends ITypeSystemInferrer> bindITypeSystemInferrer() {
		SCTUnitTypeInferrer
	}

	def Class<? extends ContextPredicateProvider> bindContextPredicateProvider() {
		SCTUnitContextPredicateProvider
	}

	override void configureIScopeProviderDelegate(Binder binder) {
		binder.bind(IScopeProvider).annotatedWith(Names.named(AbstractDeclarativeScopeProvider.NAMED_DELEGATE)).to(
			SCTUnitImportAwareScopeProvider)
	}
	
	override bindIFormatter() {
		SCTUnitFormatter
	}
	
	def Class<? extends ISyntaxErrorMessageProvider> bindISyntaxErrorMessageProvider() {
		SyntaxErrorMessageProvider
	}
	
}
