/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.scoping

import com.yakindu.sctunit.sCTUnit.CodeBlock
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.TestStatement
import com.yakindu.sctunit.sCTUnit.VariableDefinitionStatement
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractScope

import static extension org.eclipse.xtext.EcoreUtil2.*
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation

/**
 * 
 * @author jonathan thoene - Initial contribution and API
 * 
 */
class ElementReferenceScope extends AbstractScope {

	EObject context

	new(IScope outer, EObject context) {
		super(outer, false)
		this.context = context
	}

	override protected getAllLocalElements() {
		var result = newArrayList()
		result.addProgramBlocks(context)
		result.addGlobalVariables(context)
		result.addOperationParameters(context)
		Scopes.scopedElementsFor(result)
	}

	def addGlobalVariables(List<EObject> result, EObject object) {
		if (object.getContainerOfType(SCTUnitClass) === null) {
			return;
		} 
		result += object.getContainerOfType(SCTUnitClass).variableDefinitions.map[stmt|stmt.definition]
	}

	def addOperationParameters(List<EObject> result, EObject object) {
		var op = object.getContainerOfType(SCTUnitOperation)
		if (op !== null) {
			result += op.parameters
		}
	}

	def void addProgramBlocks(List<EObject> result, EObject object) {
		var programBlock = object.getContainerOfType(CodeBlock)
		if (programBlock !== null) {
			var index = programBlock.code.indexOf(object.getContainerOfType(TestStatement))
			if (index >= 0) {
				result += programBlock.code.subList(0, index).filter(VariableDefinitionStatement).map [stmt|
					stmt.definition
				]
			} else {
				result += programBlock.code.filter(VariableDefinitionStatement).map[stmt|stmt.definition]
			}
			addProgramBlocks(result, programBlock.eContainer)
		}
	}
}
