/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.validation

import com.yakindu.base.base.BasePackage
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.TestPackage
import org.eclipse.xtext.validation.Check

/**
 * This class contains the validation rules regarding the SctUnit class itself. 
 * 
 * @author lkovacs
 */
class SCTUnitClassValidator extends BaseSCTUnitValidator {

	@Check
	def checkNamingRegardingStatechart(SCTUnitClass it) {
		if (name?.equals(statechart?.name))
			if (eContainer instanceof TestPackage) {
				val testPack = eContainer as TestPackage
				if (testPack.name == statechart.namespace)
					error(String.format(CONFLICTING_NAMES, statechart.name), it,
						BasePackage.Literals.NAMED_ELEMENT__NAME);
			} else
				error(String.format(CONFLICTING_NAMES, statechart.name), it, BasePackage.Literals.NAMED_ELEMENT__NAME);
	}
}
