/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sctunit.validation

import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.validation.ComposedChecks
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.validation.IValidationIssueAcceptor
import com.yakindu.sctunit.sCTUnit.MockingStatement

@ComposedChecks(validators=#[AssertionStatementValidator, MockingStatementValidator, ReturnStatementValidator,
	SCTUnitOperationValidator, LoopStatementValidator, SCTUnitExpressionsValidator, ProceedExpressionValidator,
	TriggerWithoutEventExpressionValidator, SCTUnitSuiteValidator, SCTUnitClassValidator, SCTUnitNamesAreUniqueValidator])
class SCTUnitValidator extends AbstractSCTUnitValidator implements IValidationIssueAcceptor, SCTUnitValidationMessages {

	override void checkOperationArguments_FeatureCall(FeatureCall call) {
		var MockingStatement container = EcoreUtil2.getContainerOfType(call, MockingStatement)
		if (container !== null) { // Overwritten because you don't necessarily need Arguments to mock
			// or
			// verify an operation. Operation mocks and Operation verifies can
			// either reference a FeatureCall or an ElementReferenceExpression
		} else {
			super.checkOperationArguments_FeatureCall(call)
		}
	}

	override void checkOperationArguments_TypedElementReferenceExpression(ElementReferenceExpression call) {
		var MockingStatement container = EcoreUtil2.getContainerOfType(call, MockingStatement)
		if (container !== null) { // Overwritten because you don't necessarily need Arguments to mock
			// or
			// verify an operation. Operation mocks and Operation verifies can
			// either reference a FeatureCall or an ElementReferenceExpression
		} else {
			super.checkOperationArguments_TypedElementReferenceExpression(call)
		}
	}
}
