/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.simulation.core.sexec.interpreter

import com.google.inject.Inject
import com.yakindu.base.types.Type
import com.yakindu.sct.model.sruntime.ExecutionContext

import static com.yakindu.sct.simulation.core.sexec.interpreter.SexecInterpreter.*

/**
 * Provides extension functions for interaction with a runtime state machine instances provided by the
 * interpreter.
 * 
 * @author axel terfloth
 */
class StatechartRuntimeExtension {
	
	@Inject protected extension SexecInterpreter interpreter // TODO: this should not be SexecInterpreter

	def newInstance(Type type) {
		interpreter.newInstance(type) as ExecutionContext	
	}
	
	def void init(ExecutionContext instance) {		
		instance.invokeOperation(INIT)				
	}
	
	def void enter(ExecutionContext instance) {
		instance.invokeOperation(ENTER)
	}

	def void exit(ExecutionContext instance) {		
		instance.invokeOperation(EXIT)		
	}

	def void runCycle(ExecutionContext instance) {
		instance.invokeOperation(RUN_CYCLE)
	}
	
	def void triggerWithoutEvent(ExecutionContext instance) {
		instance.invokeOperation(TRIGGER_WITHOUT_EVENT)
	}
	
	def boolean isActive(ExecutionContext instance) {
		instance.invokeOperation(IS_ACTIVE) == true
	}
	
	def boolean isFinal(ExecutionContext instance) {
		instance.invokeOperation(IS_FINAL) == true
	}
	
	def boolean isStateActive(ExecutionContext instance, String stateName) {
		instance.invokeOperation(IS_STATE_ACTIVE, stateName) == true
	}

	
	def void suspend() {
		interpreter.suspend
	}

	def void resume() {
		interpreter.resume
	}

	
	def void terminate() {
		interpreter.terminate
	}

	
	def set(Object slot, Object value) {
		interpreter.setValue(slot, value)
	}
}