/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.base

import com.yakindu.sct.model.sgen.FeatureConfiguration
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sctunit.generator.base.features.BaseFeaturesLibraryConstants.*

class SCTUnitGenmodelEntries {
	
	def getLicenseFeature(GeneratorEntry it) {
		getFeatureConfiguration(LICENSE_HEADER)
	}
	
	def FeatureParameterValue getLicenseTextParameter(GeneratorEntry it) {
		licenseFeature?.getParameterValue(LICENSE_TEXT)
	}
	
	def getLicenseText(GeneratorEntry it) {
		if (licenseTextParameter !== null) {
			return "/** " + licenseTextParameter.stringValue.trim + " */"
		}
		return LICENSE_STANDARD_TEXT
	}
	
	def getLibraryTargetFeature(GeneratorEntry it) {
		getFeatureConfiguration(OUTLET_FEATURE).getParameterValue(OUTLET_FEATURE_LIBRARY_TARGET_FOLDER)
	}
	
	// GeneratorEntry values
	def getTargetFolderString(GeneratorEntry entry) {
		var FeatureConfiguration outletConfig = entry.getFeatureConfiguration(OUTLET_FEATURE);
		var String projectName = outletConfig.getParameterValue(OUTLET_FEATURE_TARGET_FOLDER).getStringValue();
		return projectName;
	}
	
	def getLibraryTargetFolderString(GeneratorEntry it) {
		var FeatureConfiguration outletConfig = getFeatureConfiguration(OUTLET_FEATURE);
		var String projectName = outletConfig.getParameterValue(OUTLET_FEATURE_LIBRARY_TARGET_FOLDER).getStringValue();
		return projectName;
	}
	
	def getPackageFromOutlet(GeneratorEntry it){
		var FeatureConfiguration outletConfig = getFeatureConfiguration(OUTLET_FEATURE);
		var String projectName = outletConfig.getParameterValue(OUTLET_FEATURE_TARGET_FOLDER).getStringValue();
		if(!projectName.nullOrEmpty && projectName.contains('/')){
			var split = projectName.split('/',2);
			var pack = split.get(1);
			if(!pack.nullOrEmpty){	
				return pack.replace('/','.');
			}
		}
		return ""
	}
	
	def private getOutEventAPIFeature(GeneratorEntry it) {
		getFeatureConfiguration(FEATURE_OUT_EVENT_API)
	}
	
		
	def getOutEventObservablesUsed(GeneratorEntry it) {
		val parameter = getOutEventAPIFeature?.getParameterValue(PARAMETER_OUT_EVENT_OBSERVABLES)
		if(parameter !== null) {
			return parameter.booleanValue
		}
		false
	}
	
	def getOutEventGettersUsed(GeneratorEntry it) {
		val parameter = getOutEventAPIFeature?.getParameterValue(PARAMETER_OUT_EVENT_GETTERS)
		if(parameter !== null) {
			return parameter.booleanValue
		}
		true
	}

}
