/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.IExecutionFlowGenerator
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations.GenArtifactConfiguration
import com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.cpp.files.CycleBasedInterface
import com.yakindu.sct.generator.cpp.files.EventDrivenInterface
import com.yakindu.sct.generator.cpp.files.RxCppHeader
import com.yakindu.sct.generator.cpp.files.StatemachineHeader
import com.yakindu.sct.generator.cpp.files.StatemachineImplementation
import com.yakindu.sct.generator.cpp.files.StatemachineInterface
import com.yakindu.sct.generator.cpp.files.TimerHeader
import com.yakindu.sct.generator.cpp.files.TimerServiceHeader
import com.yakindu.sct.generator.cpp.files.TimerServiceSource
import com.yakindu.sct.generator.cpp.files.Tracing
import com.yakindu.sct.generator.cpp.files.Types
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration
import com.yakindu.sct.model.sgen.GeneratorEntry
import org.eclipse.xtext.generator.IFileSystemAccess

import static com.yakindu.sct.generator.core.filesystem.ISCTFileSystemAccess.*
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.c.AddTimeTypeCastToScheduleTimeEventModification

/**
 * This is the CPP code generators main class. 
 * 
 * @author Markus Mühlbrandt
 */
class CppGenerator implements IExecutionFlowGenerator {

	@Inject Types typesContent
	@Inject TimerHeader timerHeaderContent
	@Inject StatemachineHeader statemachineHeaderContent
	@Inject StatemachineImplementation statemachineSourceContent
	@Inject StatemachineInterface statemachineInterfaceContent
	@Inject CycleBasedInterface cycleBasedInterfaceContent
	@Inject EventDrivenInterface eventDrivenInterfaceContent
	@Inject Tracing tracingContent
	@Inject RxCppHeader rxcpp
	@Inject extension TimerServiceHeader timerServiceHeader
	@Inject extension TimerServiceSource timerServiceSource
	
	@Inject extension SExecExtensions
	@Inject protected extension CppFileNaming
	@Inject extension ICoreLibraryHelper
	@Inject extension GenmodelEntries
	@Inject extension IFlowConfiguration
	
	@Inject IGenArtifactConfigurations locations
	@Inject AddTimeTypeCastToScheduleTimeEventModification addTimeTypeCastToScheduleTimeEvent
	

	override generate(ExecutionFlow flow, GeneratorEntry entry, ISCTFileSystemAccess fsa) {
		
		addTimeTypeCastToScheduleTimeEvent.modify(flow)
		
		initGenerationArtifacts(flow, entry, locations)
		generateArtifacts(flow, entry, fsa, locations);
	}

	def generateArtifacts(ExecutionFlow flow, GeneratorEntry entry, IFileSystemAccess fsa,
		IGenArtifactConfigurations locations) {
		for (GenArtifactConfiguration a : locations.configurations) {
			if (!a.skip) {
				fsa.generateFile(a.getName, a.getOutputName, a.getArtifact.fileContent(flow, entry, locations))
			}
		}
	}

	def initGenerationArtifacts(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		locations.configure(typesModule.h, entry.libraryOutput, typesContent, entry.skipLibraryFiles)
		
		locations.configure(statemachineModule.h, entry.libraryOutput, statemachineInterfaceContent, entry.skipLibraryFiles)
		if (isCycleBased || entry.timerService) {
			locations.configure(cycleBasedModule.h, entry.libraryOutput, cycleBasedInterfaceContent, entry.skipLibraryFiles)
		}
		if (!isCycleBased) {
			locations.configure(eventDrivenModule.h, entry.libraryOutput, eventDrivenInterfaceContent, entry.skipLibraryFiles)
		}
		
		if (flow.timed || entry.timerService) {
			locations.configure(timerModule.h, entry.libraryOutput, timerHeaderContent, entry.skipLibraryFiles)
		}

		locations.configure(flow.module.h, entry.headerOutput, statemachineHeaderContent)
		locations.configure(flow.module.cpp, entry.sourceOutput, statemachineSourceContent)
		
		if (entry.tracingUsed) {
			locations.configure(tracingModule.h, entry.libraryOutput, tracingContent);
		}
		if (entry.outEventObservablesUsed && flow.hasOutgoingEvents) {
			locations.configure(rxcModule.h, entry.libraryOutput, rxcpp, getSkipLibraryFiles(entry))
		}
		if(entry.timerService) {
			locations.configure(timerServiceModule.h, entry.libraryOutput, timerServiceHeader, getSkipLibraryFiles(entry))
			locations.configure(timerServiceModule.cpp, entry.libraryOutput, timerServiceSource, getSkipLibraryFiles(entry))
		}
	}

	def protected getHeaderOutput(GeneratorEntry entry) {
		if (entry.apiTargetFolderValue !== null) {
			API_TARGET_FOLDER_OUTPUT
		} else {
			TARGET_FOLDER_OUTPUT
		}
	}

	def protected getLibraryOutput(GeneratorEntry entry) {
		if (entry.libraryTargetFolderValue !== null) {
			LIBRARY_TARGET_FOLDER_OUTPUT
		} else {
			entry.headerOutput
		}
	}

	def protected getSourceOutput(GeneratorEntry entry) {
		TARGET_FOLDER_OUTPUT
	}
	
	def dispatch String fileContent(IContentTemplate<ExecutionFlow> it, ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		it.content(flow, entry, locations)
	}
	
	def dispatch String fileContent(Object it, Object p, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		""
	}
	

}
