/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.sct.generator.c.IncludeProvider
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.List

class CppInterfaceIncludeProvider implements IncludeProvider {

	@Inject protected extension CppFileNaming
	@Inject protected extension SExecExtensions
	@Inject extension GenmodelEntries
	@Inject extension GeneratorEntry entry
	@Inject extension IFlowConfiguration

	override getIncludes(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs) {
		val List<CharSequence> includes = newArrayList
		includes += include((statemachineModule.h).relativeTo(module.h))
		includes += include((
				if(isCycleBased) cycleBasedModule.h else eventDrivenModule.h
		).relativeTo(module.h))
		if (timed) {
			includes +=  include((timerModule.h).relativeTo(module.h))
		}
		if (entry.tracingUsed) {
			includes += include((tracingModule.h).relativeTo(module.h))
		}
			
		includes
	}
		
	def include(CharSequence it)'''
	#include "«it»"
	'''
}
