/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Property
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.List
import org.eclipse.emf.ecore.EObject

import static com.yakindu.sct.generator.c.CGeneratorConstants.*
import static com.yakindu.sct.generator.core.submodules.lifecycle.IsActive.*
import static com.yakindu.sct.generator.core.submodules.lifecycle.IsFinal.*
import static com.yakindu.sct.generator.core.submodules.lifecycle.IsStateActive.*
import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

/**
 * @author Markus Mühlbrands - Initial contribution and API
 * @author Axel Terfloth - updates
 */
class CppNaming extends Naming {

	@Inject protected extension CppTypes
	@Inject protected extension SExecExtensions
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension INamingService
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension StatechartUtil
	@Inject protected extension OriginTracing
	@Inject protected extension GeneratorPredicate
	@Inject protected extension EventBuffer
	@Inject protected extension CppPointers
	
	@Inject GeneratorEntry entry

	def abstractModule(ExecutionFlow it) {
		module() + 'Interface'
	}

	def cycleBasedInterface() {
		SM_CYCLEBASED_INTERFACE
	}
	
	def statemachineInterface() {
		SM_INTERFACE
	}
	
	def eventDrivenInterface() {
		SM_EVENTDRIVEN_INTERFACE
	}
	
	def statesCountConst() {
		STATES_COUNT
	}

	def orthogonalStatesConst() {
		MAX_ORTHOGONAL_STATES
	}

	def historyStatesConst() {
		MAX_HISTORY_STATES
	}

	def timedInterface() {
		SM_TIMED_INTERFACE
	}

	def timerInterface() {
		TIMER_INTERFACE
	}
	
	def timerInstance() {
		TIMER_SERVICE_MEMBER
	}
	
	def timerServiceImplementation() {
		TIMER_SERVICE_IMPLEMENTATION
	}
	
	def timerServiceImplementationTask() {
		TIMER_SERVICE_IMPLEMENTATION_TASK
	}
	
	def timerArgument() {
		TIMER_SERVICE_ARGUMENT
	}

	def timeEventsCountConst() {
		TIME_EVENTS_COUNT
	}

	def timeEventsCountparallelConst() {
		PARALLEL_TIME_EVENTS_COUNT
	}

	def timeEventsInstance() {
		TIME_EVENTS
	}
	
	override setTimerFctID(ExecutionFlow it) {
		'setTimer'
	}
	
	override unsetTimerFctID(ExecutionFlow it) {
		'unsetTimer'
	}
	
	override enterStateTracingFctID(ExecutionFlow it) {
		'stateEntered'
	}
	
	override exitStateTracingFctID(ExecutionFlow it) {
		'stateExited'
	}
	
	override triggerWithoutEventFctID(ExecutionFlow it) {
		'triggerWithoutEvent'
	}
	
	def traceObserver() {
		TRACE_OBSERVER
	}
	
	def scNS() {
		SC_NS
	}
	
	def scTraceNS() {
		SC_TRACE_NS
	}
	
	def scTimerNS() {
		SC_TIMER_NS
	}
	
	def scRxNS() {
		SC_RX_NS
	}
	
	def parentArgument() {
		PARENT_ARGUMENT
	} 
	
	def parentMember() {
		PARENT_MEMBER
	}

	def signature(OperationDefinition it) '''
	«typeSpecifier.targetLanguageName» «name.asEscapedIdentifier»(«FOR parameter : parameters SEPARATOR ', '»«IF parameter.isVarArgs»...«ELSE»«parameter.typeSpecifier.
		targetLanguageName» «parameter.identifier»«ENDIF»«ENDFOR»)'''

	def OCB_InterfaceSetterDeclaration(StatechartScope scope, boolean fqn) '''
	void «IF fqn»«scope.flow.module»::«scope.scopedAccess»«ENDIF»set«scope.interfaceOCBName»(«scope.interfaceOCBName»* operationCallback)'''

	def protected identifier(Parameter parameter) {
		if (parameter.name.isKeyword) {
			return parameter.name + "Arg"
		} else {
			parameter.name
		}
	}

	override dispatch instance(InternalScope it) {
		'iface' + interfaceName.asIdentifier.toFirstUpper
	}

	def OCB_Instance(Scope it) {
		it.instance + "OperationCallback"
	}
	
	def tracingInstance(ExecutionFlow it) {
		"iface" + traceObserver
	}
	
	override enumMemberNamePrefix(EObject it) {
		scope.interfaceName
	}

	override dispatch interfaceName(InternalScope it) { "Internal" }
	override dispatch interfaceName(InterfaceScope it) { (name ?: "").toFirstUpper }

	def dispatch String asGetter(InterfaceScope it) {
		if(name !== null) {
			return name.toFirstLower.asEscapedIdentifier
		}
		return '''Can not generate getter for «it.class.name»'''
	}
	
	def dispatch String asGetter(InternalScope it) {
		'''Can not generate getter for «it.class.name»'''
	}

	def dispatch String getSimpleName(InterfaceScope it) {
		if (name !== null) {
			return name
		} else {
			return "default";
		}
	}

	def dispatch String getSimpleName(InternalScope it) {
		"internal"
	}

	def String getInterfaceOCBName(Scope it) {
		switch it {
			InterfaceScope: return "OperationCallback"
			InternalScope: return "InternalOperationCallback"
		}
	}

	override asFunction(Operation it) {
		name.asEscapedIdentifier
	}
	
	override enterFctID(ExecutionFlow it) {
		ENTER
	}
	
	override exitFctID(ExecutionFlow it) {
		EXIT
	}
	
	override runCycleFctID(ExecutionFlow it) {
		'runCycle'
	}
	
	override isActiveFctID(ExecutionFlow it) {
		isActiveFncName
	}
	
	override asRaiser(EventDefinition it) {
		'raise' + name.asIdentifier.toFirstUpper
	}

	override asRaised(EventDefinition it) {
		'isRaised' + name.asIdentifier.toFirstUpper
	}

	override dispatch asGetter(EventDefinition it) {
		'get' + name.asIdentifier.toFirstUpper + 'Value'
	}

	override dispatch asGetter(VariableDefinition it) {
		'get' + name.asIdentifier.toFirstUpper
	}

	override dispatch asSetter(Declaration it) {
		'set' + name.asIdentifier.toFirstUpper
	}
	
	override asObservableGetter(Event it) {
		'''get«name.asIdentifier.toFirstUpper»'''
	}
	
	def asObserverGetter(Event it) {
		'''get«name.asIdentifier.toFirstUpper»'''
	}
	
	def interfaceMember() {
		'''interface'''
	}
	
	def observerClass(Event it) {
		'''«name.toFirstUpper»Observer'''
	}
	
	def observer(Event it) {
		'''«name»_observer'''
	}
	
	def subscription(Event it) {
		'''«name»_subscription'''
	}

	override raiseTimeEventFctID(ExecutionFlow it) {
		'raiseTimeEvent'
	}

	override isStateActiveFctID(ExecutionFlow it) {
		isStateActiveFncName
	}
	
	override isFinalFctID(ExecutionFlow it) {
		isFinalFncName
	}
	
	def numTimeEventsFctID(ExecutionFlow it) {
		"getNumberOfParallelTimeEvents"
	}

	override dispatch access(OperationDefinition it) {
		if (entry.useStaticOPC) {
			return '''«(scope as StatechartScope).interfaceOCBName»::«asFunction»'''
		}
		return '''«scope.namedInstanceAccess»«scope.OCB_Instance»->«asFunction»'''
	}
	
	override dispatch access(Operation it) '''«name»'''

	override dispatch access(TimeEvent it) '''«timeEventsInstance»[«indexOf»]'''

	override dispatch access(VariableDefinition it) {
		if (external) {
			return '''«asGetter»()'''
		} else {
			if (const) {
				return '''«flow.module»::«scope.scopedAccess»«localAccess»'''
			} else {
				return '''«scope.namedInstanceAccess»«localAccess»'''
			}
		}
	}
	
	override dispatch String access(Property definition) {
		val origin = definition.type.originTraces.head
		if (origin instanceof InterfaceScope) {
			if(!definition.type.isEventBuffer) {
				return '''«origin.asGetter»()'''
			}
		}
		'''«super._access(definition)»'''
	}
	
	override dispatch access(EventDefinition it) {
		if (external)
			'''«asRaised»()'''
		else
			'''«scope.namedInstanceAccess»«localAccess»'''
	}

	override dispatch valueAccess(Declaration it) '''«scope.namedInstanceAccess»«name.asIdentifier.value»'''
	
	def dispatch observableAccess(Declaration it) '''«scope.namedInstanceAccess»«observable»'''
	
	def dispatch observableAccess(EObject it) '''Can not access object of type '«it.class.name»'.'''
	
	def observable(Declaration it) {it.name.asIdentifier + separator + 'observable'}

	def dispatch localAccess(VariableDefinition it) '''«name.asEscapedIdentifier»'''

	def dispatch localAccess(Event it) '''«name.asIdentifier.raised»'''

	def dispatch localValueAccess(Event it) '''«name.asIdentifier.value»'''
	
	def dispatch localValueAccess(EObject it) ''''''

	override valueParams(EventDefinition it) {
		if (hasValue)
			typeSpecifier.targetLanguageName + " " + name.asParameter
		else
			''
	}
	
	protected def isExternal(EObject it) {
		eContainer instanceof ComplexType
	}
	
	def List<String> statechartNamespace(ExecutionFlow it) {
		statechart.statechartNamespace
	}
	
	def List<String> statechartNamespace(Statechart sct) {
		if(sct === null) {
			return emptyList
		}
		var ns = sct.namespace
		if(ns === null || ns == "") {
			return emptyList
		}
		return newArrayList(ns.replace(".", "::").replace("/", "::").split("::").filter[!nullOrEmpty])
	}
	
	override stateEnumAccess(Enumerator it) {
		val statechart = eContainer.getOriginStatechart
		val state = originState		
		if (state !== null)
			'''«statechart.typeName»::«state.stateName.asEscapedIdentifier»'''
		else
			'''«statechart.typeName»::«statechart.null_state»'''
	}
	
	/** TODO: copied from SCTUnitCppNaming */
	def private typeName(Statechart it) {
		if(namespace.nullOrEmpty)
			name.asIdentifier.toFirstUpper
		else
			namespace.replace(".", "::").replace("/", "::") + "::" + name.asIdentifier.toFirstUpper
	}
	
	def scopedAccess(Scope it) {
		'''«IF isNamedScope»«interfaceName»::«ENDIF»'''
	}
	
	def namedInstanceAccess(Scope it) {
		'''«IF isNamedScope»«instance».«ENDIF»'''
	}
	
	def isTopLevelPackage(EObject it) {
		return eContainer === null
	}
	
	def dispatch String asParameter(EventDefinition it){
		name.asParameter
	}
	
	def dispatch String asParameter(String it){
		asIdentifier + "_"
	}
	
	def ifaceAcces(){
		"->"
	}
	
	def ifaceReference(){
		"*"
	}
	
	def ifaceAsReference(){
		"&"
	}
	
}
