/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.IncludeProvider
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import java.util.List

/**
 * @author robert rudi
 * 
 * Adds required include for the C++ event driven case.
 */
class CppEventDrivenIncludeProvider implements IncludeProvider {
	
	@Inject protected extension GeneratorPredicate
	@Inject protected extension EventQueue
	
	override getIncludes(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs) {
		val List<CharSequence> includes = newArrayList
		if (requiresEventQueue) {
			includes += "#include <deque>"
		}
		includes
	}
	
}