/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.features

import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.cpp.features.CPPFeatureConstants.Visibility
import com.yakindu.sct.model.sgen.GeneratorEntry

class GenmodelEntriesExtension extends GenmodelEntries {

	def private getGeneratorOptionsFeature(GeneratorEntry it) {
		getFeatureConfiguration(CPPFeatureConstants::FEATURE_GENERATOR_OPTIONS)
	}
	
	def private getVisibilityParameter(GeneratorEntry it) {
		generatorOptionsFeature?.getParameterValue(CPPFeatureConstants.PARAMETER_INNER_FUNCTION_VISIBILITY)
	}
	
	def getInnerClassVisibility(GeneratorEntry it) {
		if (visibilityParameter !== null) {
			return visibilityParameter.stringValue
		}
		return Visibility.PRIVATE.toString.toLowerCase
	}

	def private getStaticOPCParameter(GeneratorEntry it) {
		generatorOptionsFeature?.getParameterValue(CPPFeatureConstants.PARAMETER_STATIC_OPC)
	}

	def useStaticOPC(GeneratorEntry it) {
		if (staticOPCParameter !== null) {
			return staticOPCParameter.booleanValue
		}
		return false
	}
	
	def private getSmartPointers(GeneratorEntry it) {
		generatorOptionsFeature?.getParameterValue(CPPFeatureConstants.SMART_POINTERS)
	}

	def usePlainPointers(GeneratorEntry it) {
		if (smartPointers !== null) {
			return !smartPointers.booleanValue
		}
		return true
	}
	
	def useSmartPointers(GeneratorEntry it) {
		if (smartPointers !== null) {
			return smartPointers.booleanValue
		}
		return false
	}

	def usePlainOperationCallbackPointers(GeneratorEntry it) {
		return !useSmartPointers
	}
	
	def usePlainStatemachineRefPointers(GeneratorEntry it) {
		return true
	}
	
	override getSourceFilenameExtension(GeneratorEntry it) {
		sourceFilenameExtensionParameter?.stringValue?:"cpp"
	}
}
