/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class EventDrivenInterface implements IContentTemplate<ExecutionFlow> {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension GenmodelEntriesExtension
	
	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#ifndef «eventDrivenModule.define»_H_
		#define «eventDrivenModule.define»_H_
		
		#include "«statemachineModule.h»"
		
		namespace sc {
		
		/*! \file
		Interface for event-driven state machines.
		*/
		class «eventDrivenInterface» : public sc::«statemachineInterface»
		{
			public:
			
				virtual ~«eventDrivenInterface»() = 0;
			
				/*! Start a run-to-completion step without any event.
				*/
				virtual void «triggerWithoutEventFctID»() = 0;
		};
		
		inline «eventDrivenInterface»::~«eventDrivenInterface»() {}
		
		} /* namespace sc */
		
		#endif /* «eventDrivenModule.define»_H_ */
		'''
	}
	
}