/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author aterfloth
 */
class RxCppHeader implements IContentTemplate<ExecutionFlow> {
	
	@Inject extension Literals
	@Inject extension CppSpecifiers
	@Inject extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject extension GenmodelEntries

	override content(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations locations) '''
		«entry.licenseText»
		
		#ifndef «rxcModule.define»_H_
		#define «rxcModule.define»_H_
		
		«locations.includes»
		
		namespace sc {
		namespace rx {
		
		template<class T> class Observer;
		template<> class Observer<void> ;
		template<class T> class subscription;
		template<class T> class Observable;
		template<> class Observable<void> ;
		
		template<class T>
		class Observer {
		public:
			virtual ~Observer() {
			}
			virtual void next(T value) = 0;
		};
		
		template<>
		class Observer<void> {
		public:
			virtual ~Observer() {
			}
			virtual void next() = 0;
		};
		
		«singleSubscriptionObserver»
		
		«subscription»
		
		«observableBase»
		
		«observableT»
		
		«observableVoid»
		
		} /* namespace sc::rx */
		} /* namespace sc */
		
		#endif /* «rxcModule.define»_H_ */
	'''
	
	def protected includes(extension IGenArtifactConfigurations locations){
		'''#include "«(typesModule.h).relativeTo(rxcModule.h)»"
		'''
	}
	
	def protected singleSubscriptionObserver()'''
			template<class T>
			class SingleSubscriptionObserver: public Observer<T> {
			public:
				SingleSubscriptionObserver()«_noexcept» :
						subscription(this) {
				}
			
				bool subscribe(sc::rx::Observable<T> *o)«_noexcept» {
					return o->subscribe(&subscription);
				}
			
				bool unsubscribe(sc::rx::Observable<T> *o)«_noexcept» {
					return o->unsubscribe(&subscription);
				}
				
				virtual ~SingleSubscriptionObserver() {}
			
			protected:
				sc::rx::subscription<T> subscription;
			};
	'''
	
	def protected subscription()'''
	template<class T>
	class subscription {
	public:
		subscription(Observer<T> *o)«_noexcept» :
				observer(o), next(«NULL_LITERAL») {
		}

		Observer<T> *observer;
		subscription<T> *next;
	};
	'''
	
	def protected observableBase()'''
		template<class T> class ObservableBase {
		public:
			ObservableBase() «_noexcept» :
					subscriptions(«NULL_LITERAL») {
			}
		
			bool subscribe(subscription<T> *s)«_noexcept» {
				if (s != «NULL_LITERAL» && s->observer != «NULL_LITERAL» && s->next == «NULL_LITERAL») {
					subscription<T> *currentSub = this->subscriptions;
					s->next = (currentSub != «NULL_LITERAL») ? currentSub : s;
					this->subscriptions = s;
					return true;
				}
				return false;
			}
		
			bool unsubscribe(subscription<T> *s)«_noexcept» {
				if (s != «NULL_LITERAL» && this->subscriptions != «NULL_LITERAL») {
					if (this->subscriptions == s) {
						this->subscriptions = (s->next != s) ? s->next : «NULL_LITERAL»;
						s->next = «NULL_LITERAL»;
		
						return true;
					}
		
					sc::rx::subscription<T> *sub = this->subscriptions;
					while (sub != «NULL_LITERAL») {
						if (sub->next != sub && sub->next == s) {
							sub->next = (s->next != s) ? s->next : sub;
							return true;
						}
		
						sub = (sub->next != sub) ? sub->next : «NULL_LITERAL»;
					}
				}
				return false;
			}
			
			virtual ~ObservableBase() {}
		
		protected:
			subscription<T> *subscriptions;
		
		};
	'''
	
	def protected observableT()'''
	template<class T>
	class Observable: public ObservableBase<T> {
	
	public:
	
		void next(T value) {
			subscription<T> *sub = this->subscriptions;
			while (sub != «NULL_LITERAL») {
				if (sub->observer != «NULL_LITERAL») {
					sub->observer->next(value);
				}
				sub = (sub->next != sub) ? sub->next : «NULL_LITERAL»;
			}
		}
		
		virtual ~Observable() {}
	
	};
	'''
	
	def protected observableVoid()'''
	template<>
	class Observable<void> : public ObservableBase<void> {
	
	public:
		void next() {
			subscription<void> *sub = this->subscriptions;
			while (sub != «NULL_LITERAL») {
				if (sub->observer != «NULL_LITERAL») {
					sub->observer->next();
				}
				sub = (sub->next != sub) ? sub->next : «NULL_LITERAL»;
			}
		}
		
		virtual ~Observable() {}
	};
	''' 
}
