/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.IncludeProvider
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CodeGeneratorFragmentProvider
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.Set

class StatemachineHeader extends com.yakindu.sct.generator.c.files.StatemachineHeader {

	@Inject protected Set<IncludeProvider> includeProviders
	@Inject protected CodeGeneratorFragmentProvider fragmentProvider

	@Inject protected extension CppNaming
	@Inject protected extension GenmodelEntriesExtension

	protected GeneratorEntry entry
	
	override content(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) {
		this.entry = entry
		val namespace = statechartNamespace
		'''
			«entry.licenseText»
			
			#ifndef «module().define»_H_
			#define «module().define»_H_

			«FOR ns : namespace»
				namespace «ns» {
			«ENDFOR»
			/*!
			Forward declaration for the «module» state machine.
			*/
			class «module»;
			«FOR ns : namespace»
				}
			«ENDFOR»
			
			
			«includes(artifactConfigs)»
			
			/*! \file
			Header of the state machine '«name»'.
			*/
			
			«FOR ns : namespace»
				namespace «ns» {
			«ENDFOR»
			
			«fragmentProvider.get(StatemachineHeader.simpleName, it, artifactConfigs)»
			
			«FOR ns : namespace»
				}
			«ENDFOR»
			
			#endif /* «module().define»_H_ */
		'''
	}
	
	def final includes(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs) {
		'''
			«FOR provider : includeProviders»
				«FOR i : provider.getIncludes(it, artifactConfigs)»
					«i»
				«ENDFOR»
			«ENDFOR»
		'''
	}
}
