/**
 * Copyright (c) 2020-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

class TimerHeader implements IContentTemplate<ExecutionFlow> {
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppPointers
	@Inject protected extension CppTypes
	@Inject protected extension GenmodelEntries
	
	override content(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#ifndef «timerModule.define»_H_
		#define «timerModule.define»_H_
		
		#include "«typesModule.h»"
		«memoryInclude»
		#include <cstddef>
		
		namespace sc {
		namespace timer {
		
		class «timedInterface»;
		class «timerInterface»;
		
		/*! \file
		Interface for state machines which use timed event triggers.
		*/
		class «timedInterface» {
			public:
			
				virtual ~«timedInterface»() = 0;
				
				/*!
				Set the timer service for the state machine. It must be set
				externally on a timed state machine before a run cycle can be executed.
				*/
				virtual void «SET_TIMER_SERVICE»(«sharedPtr»«scTimerNS»::«timerInterface»«pointerType» «timerInstance») = 0;
				
				/*!
				Return the currently used timer service.
				*/
				virtual «sharedPtr»«scTimerNS»::«timerInterface»«pointerType» «GET_TIMER_SERVICE»() = 0;
				
				/*!
				Callback method if a time event occurred.
				*/
				virtual void «raiseTimeEventFctID»(«sc_eventid.fqName» event) = 0;
				
				/*!
				Retrieve the number of time events that can be active at once in this state machine.
				*/
				virtual «sc_integer.fqName» «numTimeEventsFctID»() = 0;
				
		};
		
		inline «timedInterface»::~«timedInterface»() {}
		
		
		/*! \file
		Timer service interface.
		*/
		class «timerInterface»
		{
			public:
				
				virtual ~«timerInterface»() = 0;
			
				/*!
				Starts the timing for a time event.
				*/ 
				virtual void «setTimerFctID»(«sharedPtr»«timedInterface»«pointerType» statemachine, «sc_eventid.fqName» event, «sc_time.fqName» time_ms, «sc_bool.fqName» isPeriodic) = 0;
				
				/*!
				Unsets the given time event.
				*/
				virtual void «unsetTimerFctID»(«sharedPtr»«timedInterface»«pointerType» statemachine, «sc_eventid.fqName» event) = 0;
		};
		
		inline «timerInterface»::~«timerInterface»() {}
		
		} /* namespace sc::timer */
		} /* namespace sc */
		
		#endif /* «timerModule.define»_H_ */
		'''
	}
}