/**
* Copyright (c) 2022-2023 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp.files

import com.google.inject.Inject
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.types.CppTypes

class TimerServiceHeaderMethods {
	@Inject protected extension CppNaming
	@Inject protected extension CppTypes
	@Inject protected extension CppPointers
	@Inject protected extension CppSpecifiers

	def setTimer() '''
		/*! Start the timing for a time event.
		 */
		virtual void setTimer(«sharedPtr»TimedInterface «pointerType»statemachine_, «sc_eventid.fqName» event,
					«sc_time.fqName» time_ms, «sc_bool.fqName» isPeriodic)«_override»;
	'''

	def unsetTimer() '''
		/*! Unset the given time event.
		 */
		virtual void unsetTimer(«sharedPtr»TimedInterface «pointerType»statemachine_, «sc_eventid.fqName» event)«_override»;
	'''
	
	def setRuncycleTimerFor() '''
		/*! Set a timer for running cycles of the given statemachine.
		 */
		virtual void setRuncycleTimerFor(«sharedPtr»«cycleBasedInterface» «pointerType»statemachine, «sc_time.fqName» cycle_period);
	'''
	
	def unsetRuncycleTimerFor() '''
		/*! Unset timers for running cycles of the given statemachine.
		 */
		virtual void unsetRuncycleTimerFor(«sharedPtr»«cycleBasedInterface» «pointerType»statemachine);
	'''
}
