/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.library.impl

import static com.yakindu.base.types.typesystem.ITypeSystem.*
import com.yakindu.sct.generator.core.library.impl.CoreFeatureTypeLibraryProvider

class CPPFeatureTypeLibraryProvider extends CoreFeatureTypeLibraryProvider {
	override outlet() {
		super.outlet => [
			parameters += createFeatureParameter => [
				name = "apiTargetFolder"
				optional = true
				parameterType = getType(STRING)
			]
		]
	}

	def identifierSettings() {
		createFeatureType => [
			name = "IdentifierSettings"
			optional = true
			parameters += createFeatureParameter => [
				name = "moduleName"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "statemachinePrefix"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "separator"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "headerFilenameExtension"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "sourceFilenameExtension"
				optional = true
				parameterType = getType(STRING)
			]
		]
	}

	def generatorOptions() {
		createFeatureType => [
			name = "GeneratorOptions"
			optional = true
			parameters += createFeatureParameter => [
				name = "innerFunctionVisibility"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "staticOperationCallback"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "smartPointers"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def includes() {
		createFeatureType => [
			name = "Includes"
			optional = true
			parameters += createFeatureParameter => [
				name = "useRelativePaths"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "generateAllSpecifiedHeaders"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def tracing() {
		createFeatureType => [
			name = "Tracing"
			optional = true
			parameters += createFeatureParameter => [
				name = "enterState"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "exitState"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def generalFeatures() {
		createFeatureType => [
			name = "GeneralFeatures"
			optional = true
			parameters += createFeatureParameter => [
				name = "timerService"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "timerServiceTimeType"
				optional = true
				parameterType = getType(STRING)
			]
		]
	}

	override provide() {
		create([super.provide]) => [
			name = "CPP Generator"
			types += identifierSettings()
			types += generatorOptions()
			types += includes()
			types += tracing()
			types += generalFeatures()
		]
	}
}
