/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers

import com.google.inject.Inject
import com.google.inject.Provider
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.cpp.CodeGeneratorFragmentProvider
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.submodules.InterfaceFunctions
import com.yakindu.sct.generator.cpp.submodules.InternalFunctions
import com.yakindu.sct.generator.cpp.submodules.TimingFunctions
import com.yakindu.sct.generator.cpp.submodules.TracingFunctions
import com.yakindu.sct.generator.cpp.submodules.lifecycle.LifecycleFunctions
import com.yakindu.sct.generator.cpp.templates.ClassDeclaration
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.transformation.StatechartExtensions
import com.yakindu.sct.model.sexec.transformation.config.IFlowConfiguration
import com.yakindu.sct.model.sgen.GeneratorEntry

class StatemachineClassDeclaration implements ISourceFragment {
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension SExecExtensions
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension StatechartExtensions

	@Inject protected GeneratorEntry entry
	@Inject protected Provider<ClassDeclaration> classDeclProvider

	@Inject protected extension InternalFunctions
	@Inject protected extension InterfaceFunctions
	@Inject protected extension TimingFunctions
	@Inject protected extension TracingFunctions
	@Inject protected extension LifecycleFunctions
	@Inject protected extension IFlowConfiguration
	@Inject protected extension CppSpecifiers
	@Inject protected extension CppPointers
	@Inject protected extension StatemachineClass
	@Inject protected extension NamedInterfaceClasses

	@Inject protected CodeGeneratorFragmentProvider fragmentProvider

	public static final String CLASS_PUBLIC_TARGET = "Header.Class.Public"
	public static final String CLASS_PROTECTED_TARGET = "Header.Class.Protected"
	public static final String CLASS_PRIVATE_TARGET = "Header.Class.Private"
	public static final String CLASS_INNER_TARGET = "Header.Class.InnerClasses"

	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		generateClass(it, artifactConfigs, classDeclProvider.get).generate
	}

	def generateClass(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs,
		ClassDeclaration classDecl) {
		classDecl.name(module).constructors(!containsString).destructors
		interfaceExtensions.forEach[classDecl.superType(it)]

		classDecl.member(entry.innerClassVisibility, fragmentProvider.get(CLASS_INNER_TARGET, it, artifactConfigs))

		classDecl.publicMember(fragmentProvider.get(CLASS_PUBLIC_TARGET, it, artifactConfigs))

		classDecl.protectedMember(fragmentProvider.get(CLASS_PROTECTED_TARGET, it, artifactConfigs))

		classDecl.privateMember(fragmentProvider.get(CLASS_PRIVATE_TARGET, it, artifactConfigs))

		classDecl
	}

	def protected getInterfaceExtensions(ExecutionFlow flow) {

		var interfaces = newArrayList;

		if (flow.timed) {
			interfaces += '''public «scTimerNS»::«timedInterface»'''
			if(!enableShared(scTimerNS + "::" + timedInterface).nullOrEmpty)
				interfaces += enableShared(scTimerNS + "::" + timedInterface)
		}

		interfaces += '''public «scNS»::«IF isCycleBased»«cycleBasedInterface»«ELSE»«eventDrivenInterface»«ENDIF»'''

		return interfaces;
	}

	def protected constructors(ClassDeclaration classDecl, boolean noexcept) {
		classDecl.constructorDeclaration(noexcept)
	}

	def protected destructors(ClassDeclaration classDecl) {
		classDecl.destructorDeclaration(true, false)
	}

}
