/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.model.sexec.ExecutionFlow

class StatevectorDefineProvider implements ISourceFragment {
	@Inject protected extension CppNaming
	
	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		'''
		/*! Define indices of states in the StateConfVector */
		«FOR state : states»
			#define «state.stateVectorDefine» «state.stateVector.offset»
		«ENDFOR»
		'''
	}
}