/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.providers.eventdriven.classdecl

import com.google.inject.Inject
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.eventdriven.EventNaming
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

class QueueMemberProvider implements ISourceFragment {

	@Inject protected extension EventQueue

	@Inject protected extension EventNaming
	@Inject protected extension GeneratorPredicate
	@Inject protected extension CppTypes

	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		'''
			«IF requiresInternalEventQueue»
				std::deque<«eventNamespaceName»::«SCT_EVENT»*> «internalQueue»;
			«ENDIF»
			«IF needsNextEventFunction»
				«eventNamespaceName»::«SCT_EVENT»* «nextEventFctID»();
			«ENDIF»
			«IF needsDispatchEventFunction»
				«sc_bool.fqName» «dispatchEventFctID»(«eventNamespaceName»::«SCT_EVENT» * event);
			«ENDIF»
			«IF needsTimedEventNameFunction»
				«eventNamespaceName»::«eventEnumName» «timedEventNameFctID»(«sc_eventid.fqName» evid);
			«ENDIF»
			«IF requiresIncomingEventQueue»
				std::deque<«eventNamespaceName»::«SCT_EVENT»*> «inEventQueue»;
			«ENDIF»
		'''
	}
}
