/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp.types.CppTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.cpp.CppGeneratorConstants.*

/**
 * @author Robin Herrmann
 * @author Axel Terfloth
 */
class CheckFunction {
	@Inject protected extension Literals
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension SExecExtensions
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected extension CppTypes
	@Inject protected extension CppPointers
	@Inject protected extension CppSpecifiers
	
	@Inject protected GeneratorEntry entry

	def checkFunction(ExecutionFlow it) '''
		«sc_bool.fqName» «module»::«CHECK»()«_const»«_noexcept»
		{
			«IF timed»
				if(«timerInstance» == «NULL_LITERAL») {
					return false;
				}
			«ENDIF»
			«IF !entry.useStaticOPC»
			«FOR scope : getOperations»
				if (this->«scope.namedInstanceAccess»«scope.OCB_Instance» == «NULL_LITERAL») {
					return false;
				}
			«ENDFOR»
			«ENDIF»
			return true;
		}
	'''

	def checkFunctionPrototype(ExecutionFlow it) '''
		/*! 
		 * Checks if member of the state machine must be set. For example an operation callback.
		 */
		«sc_bool.fqName» «CHECK»()«_const»«_noexcept»;
	'''

	def protected getOperations(ExecutionFlow it) {
		getInterfaces.filter[hasOperations]
	}
}
