/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp.submodules.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.cpp.eventdriven.EventNaming
import com.yakindu.sct.generator.cpp.submodules.TimingFunctions
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

class EventDrivenTimingFunctions extends TimingFunctions {
	@Inject protected extension EventNaming
	@Inject protected extension EventQueue
	
	override raiseTimeEventFunction(ExecutionFlow it) '''
		void «module»::«raiseTimeEventFctID»(«sc_eventid.fqName» evid)
		{
			if ((evid >= («sc_eventid.fqName»)«timeEventsInstance») && (evid < («sc_eventid.fqName»)(&«timeEventsInstance»[«timeEventsCountConst»])))
			{
				«IF requiresIncomingEventQueue»
					«inEventQueue».push_back(new «timedEventClassName»(«timedEventNameFctID»(evid)));
				«ELSE»
					*(«sc_bool.fqName»*)evid = true;
				«ENDIF»
				«runCycleFctID»();
			}
		}
	'''
}