/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.extensions.CodeModelGeneratorExtension
import com.yakindu.sct.generator.cpp.CppGenerator
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * Generator for C++11. It relies on the code model for code generation. 
 * 
 * @author axel terfloth
 */
class Cpp11Generator extends CppGenerator {
	
	@Inject protected extension CodeModelGeneratorExtension
	
	override initGenerationArtifacts(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) {

		flow.defineClass(entry)
				
		super.initGenerationArtifacts(flow, entry, locations)
	}
}