package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.cpp.CppObservables
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.templates.ClassDeclaration
import com.yakindu.sct.model.stext.stext.StatechartScope

class Cpp11Observables extends CppObservables{
	
	@Inject protected extension CppPointers
	
	
	override createObserverClass(Event shadowEvent, ClassDeclaration observerDecl, StatechartScope scope) {
		val result = super.createObserverClass(shadowEvent, observerDecl, scope)
		result.member(ClassDeclaration::PUBLIC, shadowEvent.createSubscriptionMember)
		return result
	}
	
	def createSubscriptionMember(Event it) {
		'''sc::rx::subscription<«typeSpecifier.targetLanguageName»> «subscription»{*this};'''
	}
	
	override CharSequence createObserverConstructor(Event it, StatechartScope scope){
		'''
			«_explicit»«observerClass»(«scope.interfaceNameByScope»* i)«_noexcept» :
				SingleSubscriptionObserver(),
				«interfaceMember»(i)
			{
				setSubscription(«subscription»);
			}
		'''
	}
	
	override CharSequence createObserver(Event it){
		'''
		«observerClass» «observer» «observerClass.multiStmInclassInit»;
		'''
	}
}