/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.generator.c.IncludeProvider
import com.yakindu.sct.generator.c.StatechartIncludeProvider
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.List

import static com.yakindu.sct.generator.c.types.CTypeSystemAccess.POINTER_TYPES

/**
 * @author lkovacs
 * 
 * Adds required include for the C++11 pointers if needed.
 */
class Cpp11PointerIncludeProvider  implements IncludeProvider {
	
	@Inject protected extension SExecExtensions
	@Inject protected extension CppPointers
	@Inject protected extension StatechartIncludeProvider
	@Inject protected extension EventQueue
	@Inject protected extension GenmodelEntriesExtension
	
	@Inject extension GeneratorEntry entry
	
	override getIncludes(ExecutionFlow it, extension IGenArtifactConfigurations artifactConfigs) {
		val List<CharSequence> includes = newArrayList
		if ((hasOperationCallbacks && !entry.usePlainOperationCallbackPointers) || requiresEventQueue ||(!collectImportedSubmachines.nullOrEmpty && !entry.usePlainStatemachineRefPointers) || usesSmartPointers) {
			includes += memoryInclude
		}
		
		includes
	}
	
	def protected usesSmartPointers(ExecutionFlow it){
		scopes.map[members].flatten.filter(TypedDeclaration).exists[td | POINTER_TYPES.exists[pt | td?.type?.name == pt]]
	}
	
}