/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codemodel

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.base.types.typesystem.ITypeValueProvider
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.core.codemodel.StatemachineEvents
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.generator.cpp11.codepattern.DoxygenComment
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.InterfaceScope
import org.eclipse.emf.ecore.util.EcoreUtil

import static com.yakindu.sct.generator.cpp.CppSpecifiers.NO_EXCEPTION

/**
 * Definition of event accessor methods. 
 * 
 * @author axel terfloth - Initial contribution.
 */
class EventAccessors extends StatemachineEvents{

	@Inject protected extension ShadowEventExtensions

	@Inject protected extension EventEnum
	@Inject protected extension EventQueueImplementation
	@Inject protected extension EventInstanceClasses
	@Inject protected extension CppPointers
	@Inject protected extension Literals
	@Inject protected extension CppSpecifiers
	@Inject protected extension CppNaming
	@Inject protected extension GeneratorPredicate
	@Inject protected extension ITypeValueProvider
	@Inject protected extension ITypeSystem
		
	@Inject protected extension IMethodCode
	@Inject protected extension DoxygenComment
	
	@Inject protected extension GenmodelEntriesExtension
	@Inject protected GeneratorEntry entry

	def void defineEventAccessors(ExecutionFlow it) {
				
		
		scopes.forEach[ s |

			s.eventDefinitions.forEach[ e |
				
				if (e.isInEvent) {
					if(e.scope instanceof InterfaceScope) {
						e.defineInEventAccessors.withInEventGenerator(e)
					} else if (shadowEvents.contains(e)) {
						e.defineShadowEventAccessors.withInEventGenerator(e)
					}	
				}
								
				if (e.isOutEvent) {
					e.defineOutEventAccessors
				}

				if (e.isLocalEvent) {
					e.defineLocalEventAccessors
				}
			]		
		]	
	}
	
	def protected defineLocalEventAccessors(EventDefinition e) {
		e.defineEventVariables
		if ( e.isLocalOutEvent )
			e.defineLocalRaiseMethod
	}
	
	
	def protected void defineOutEventAccessors(EventDefinition e) {			

			if (useOutEventGetters) {
				e.defineRaisedFlag
				e.defineIsRaisedMethod
				
				if (e.hasValue) {
					e.defineGetEventValueMethod 
					e.defineEventValueVariable => [initialValue = null]
				}						
			}
			
			if (useOutEventObservables) {
				e.defineObservable
				e.defineObservableGetter
			}
	}
	
	
	
	
	
	def protected defineObservable(EventDefinition e) {
		val member =  _variable(e.observable, _any ) => [
			documentation('''Observable for event '«e.name»' of «e.scope.scopeDescription».''')
			_private
			
			generateDeclarationWith[ '''
				«codeComment»
				«observableDeclaration(e)»
			''' ]			
		]		
		e.scope.scopeClass.features += member
		return member
	}
	
	def protected observableDeclaration(Property it, EventDefinition e)'''
	«scRxNS»::Observable<«e.typeSpecifier.targetLanguageName»> «name» = «scRxNS»::Observable<«e.typeSpecifier.targetLanguageName»>{};
	'''
		
	
	def protected withInEventGenerator(Operation it, EventDefinition e){
		if(!e.flow.isEventDriven){ _annotate(NO_EXCEPTION)}
			generateDeclarationWith[ methodDeclarationCode ]

			generateDefinitionWith['''
				«codeComment»
				void «it.asLiteral»(«e.valueParams»)«e.eventFuncThrowsException» {
					«IF e.isQueued»
						«e.flow.incomingEventQueue.queueEventCode(it, e, e.asParameter)»;
					«ELSE»
						«e.activateEventCode»
					«ENDIF»
					«IF e.flow.isEventDriven»
						«IF e.scope.namedInterfaceClass?.features?.contains(it)»«parentMember»->«ENDIF»«e.flow.runCycle.name»();
					«ENDIF»
				}
			''' ]
	}

	def protected defineLocalRaiseMethod(EventDefinition e) {
		val method = _op(e.asRaiser, _void) => [
			documentation('''Raises the out event '«e.name»' of «e.scope.scopeDescription» as a local event.''')
			_private
			if (e.hasValue) {
				_param(e.asParameter, EcoreUtil.copy(e.typeSpecifier))
			}
			if(!e.isQueued) _annotate(NO_EXCEPTION)
			generateDeclarationWith[ methodDeclarationCode ]

			generateDefinitionWith['''
				void «it.asLiteral»(«e.valueParams»)«IF !e.isQueued»«_noexcept»«ENDIF» {
					«IF e.isQueued»
						«e.flow.internalEventQueue.queueEventCode(it, e, e.asParameter)»;
					«ELSE»
						«e.activateEventCode»
					«ENDIF»
				}
			''' ]
			
		]
		
		e.scope.scopeClass.features += method
		return method
	}

	
	def protected defineIsRaisedMethod(EventDefinition e) {
		val method =  _op(e.asRaised , _boolean ) => [
			documentation('''Check if event '«e.name»' of «e.scope.scopeDescription» is raised.''')
			_public
			_annotate(NO_EXCEPTION)
			generateDeclarationWith[ methodDeclarationCode ]
			
			generateDefinitionWith['''
				«typeSpecifier.targetLanguageName» «it.asLiteral»()«_noexcept» {
					return «e.localAccess»;
				}
			''' ]
			
		]		
		e.scope.scopeClass.features += method
		return method
	}
	
	def protected defineGetEventValueMethod(EventDefinition e) {
		val method =  _op(e.asGetter.toString, EcoreUtil.copy(e.typeSpecifier) ) => [
			documentation('''Get value of event '«e.name»' of «e.scope.scopeDescription».''')
			_public
			if(!typeSpecifier.type.isString) _annotate(NO_EXCEPTION)
			generateDeclarationWith[ methodDeclarationCode ]
			
			generateDefinitionWith['''
				«typeSpecifier.targetLanguageName» «it.asLiteral»()«IF !typeSpecifier.type.isString»«_noexcept»«ENDIF» {
					return «e.localValueAccess»;
				}
			''' ]
			
		]		
		e.scope.scopeClass.features += method
		return method
	}
	
	def protected defineObservableGetter(EventDefinition e) {
		val method =  _op(e.asObservableGetter.toString, _any ) => [
			documentation('''Get observable for event '«e.name»' of «e.scope.scopeDescription».''')
			_public
			
			generateDeclarationWith[ '''
				«codeComment»
				«scRxNS»::Observable<«e.typeSpecifier.targetLanguageName»>& «name»()«_noexcept»;
			''' ]
			
			generateDefinitionWith['''
				«scRxNS»::Observable<«e.typeSpecifier.targetLanguageName»>& «it.asLiteral»()«_noexcept» {
					return this->«e.observable»;
				}
			''' ]
			
		]		
		e.scope.scopeClass.features += method
		return method
	}
	
	def protected observableTypeCalculation(EventDefinition e){
		if(e.typeSpecifier !== null) return e.typeSpecifier
		else if(!e.metaFeatures.nullOrEmpty) return e.metaFeatures.filter(Property).head.typeSpecifier
		else null
	}
	

	override queueEventCode(Property queue, Declaration context, EventDefinition e,  String valueCode) '''
	«IF entry.usePlainPointers»
	«IF e.scope.namedInterfaceClass?.features?.contains(context)»«parentMember»->«ENDIF»«queue.name».push_back(new «
				IF e.hasValue»«e.flow.eventInstanceWithValueClass.asLiteral»<«e.typeSpecifier.targetLanguageName»>(«e.enumerator.asLiteral», «valueCode»)«
				ELSE»«e.flow.eventInstanceClass.asLiteral»(«e.enumerator.asLiteral»)«ENDIF»)«ELSE»
	«IF e.scope.namedInterfaceClass?.features?.contains(context)»«parentMember»->«ENDIF»«queue.name».push_back(«uniquePtr»«
				IF e.hasValue»«e.flow.eventInstanceWithValueClass.asLiteral»<«e.typeSpecifier.targetLanguageName»>«pointerType»( new «e.flow.eventInstanceWithValueClass.asLiteral»<«e.typeSpecifier.targetLanguageName»>(«e.enumerator.asLiteral», «valueCode»))«
				ELSE»«e.flow.eventInstanceClass.asLiteral»«pointerType»(new «e.flow.eventInstanceClass.asLiteral»(«e.enumerator.asLiteral»))«ENDIF»)«ENDIF»'''		
	
	//TODO: Should be obsolate
	override raised(CharSequence it) { it + separator + 'raised' }
	//TODO: Should be obsolate
	override value(CharSequence it) { it + separator + 'value' }
	
}