/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.yakindu.base.types.Operation
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppExpressionsGenerator
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppSpecifiers

/**
 * The standard implementation pattern for method generation. 
 * 
 * @author axel terfloth - Initial contribution.
 */
class MethodCode implements IMethodCode{
	
	@Inject protected extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject protected extension CppSpecifiers
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension CppExpressionsGenerator
	@Inject protected extension DoxygenComment
	
	override methodDeclarationCode(Operation it) '''
		«codeComment»
		«IF static»static «ENDIF»«typeSpecifier.targetLanguageName» «name»(«FOR p:parameters SEPARATOR ","»«p.typeSpecifier.targetLanguageName» «p.name»«ENDFOR»)«IF noException»«_noexcept»«ENDIF»;
	'''
	
	
	override methodDefinitionCode(Operation it) '''
		«codeComment»
		«typeSpecifier.targetLanguageName» «execution_flow.module»::«name»(«FOR p:parameters SEPARATOR ","»«p.typeSpecifier.targetLanguageName» «p.name»«ENDFOR»)«IF noException»«_noexcept»«ENDIF» «it.implementation.code»
	'''	
	
}