/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.files

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.CppSpecifiers
import com.yakindu.sct.generator.cpp.files.RxCppHeader

/**
 * @author lkovacs
 */
class Cpp11RxCppHeaderStaticAlloc extends RxCppHeader{
	
	@Inject protected extension CppPointers
	@Inject protected extension CppSpecifiers
	@Inject protected extension Literals
	
	override includes(extension IGenArtifactConfigurations locations){
		super.includes(locations) +
		'''
		«memoryInclude»
		#include <vector>
		#include <algorithm>
		#include <functional>
		'''
	}
	
	override protected singleSubscriptionObserver()'''
	template<class T>
	class SingleSubscriptionObserver: public Observer<T> {
	public:
		SingleSubscriptionObserver()«_noexcept» : subscription(nullptr) {
		}
	
		bool subscribe(sc::rx::Observable<T> &o)«_noexcept» {
			if (!subscription) {
				return false;
			}
			return o.subscribe(*subscription);
		}
	
		bool unsubscribe(sc::rx::Observable<T> &o)«_noexcept» {
			if (!subscription) {
				return false;
			}
			return o.unsubscribe(*subscription);
		}
	
		void setSubscription(sc::rx::subscription<T> &s)«_noexcept» {
				subscription = &s;
		}
		
		virtual ~SingleSubscriptionObserver() = default;
	
	
	protected:
		sc::rx::subscription<T> *subscription;
	};
	'''
	
	override protected subscription()'''
	template<class T> class ObservableBase;
	
	template<class T>
	class subscription {
	protected:
		Observer<T> *observer;
		subscription<T> *next;
		friend class ObservableBase<T>;
		friend class Observable<T>;
	public:
		subscription() «_noexcept» : 
			observer(«NULL_LITERAL»), next(«NULL_LITERAL») {
		}
	
		subscription(Observer<T> &o)«_noexcept» :
			observer(&o), next(«NULL_LITERAL») {
		}
			
		bool operator==(const subscription &other) const «_noexcept»{
			return this == &other;
		}
		
		bool operator!=(const subscription &other) const «_noexcept» {
			return !(*this == other);
		}
		
		Observer<T> &operator*() const «_noexcept» {
			return *observer;
		}
		
		Observer<T> *operator->() const «_noexcept» {
			return observer;
		}
		
		operator bool() const «_noexcept» {
			return observer != nullptr;
		}
		
		virtual ~subscription() = default;
	};
	'''
	
	override protected observableBase()'''
		template<class T> class ObservableBase {
		public:
			ObservableBase() «_noexcept» :
					subscriptions(«NULL_LITERAL») {
			}
		
			bool subscribe(subscription<T> &s)«_noexcept» {
				if (s && s.next == «NULL_LITERAL») {
					subscription<T> *currentSub = this->subscriptions;
					s.next = (currentSub != «NULL_LITERAL») ? currentSub : &s;
					this->subscriptions = &s;
					return true;
				}
				return false;
			}
		
			bool unsubscribe(subscription<T> &s)«_noexcept» {
				if (this->subscriptions != «NULL_LITERAL») {
					if (*(this->subscriptions) == s) {
						this->subscriptions = (*(s.next) != s) ? s.next : «NULL_LITERAL»;
						s.next = «NULL_LITERAL»;
		
						return true;
					}
		
					sc::rx::subscription<T> *sub = this->subscriptions;
					while (sub != «NULL_LITERAL») {
						if (sub->next != sub && *(sub->next) == s) {
							sub->next = (*(s.next) != s) ? s.next : sub;
							return true;
						}
		
						sub = (sub->next != sub) ? sub->next : «NULL_LITERAL»;
					}
				}
				return false;
			}
			
			virtual ~ObservableBase() = default;
		
		protected:
			subscription<T> *subscriptions;
		
		};
	'''
	
	override protected observableT()'''
	template<class T>
	class Observable: public ObservableBase<T> {
	
	public:
	
		void next(T value) {
			subscription<T> *sub = this->subscriptions;
			while (sub != «NULL_LITERAL») {
				if (*sub) {
					(*sub)->next(value);
				}
				sub = (sub->next != sub) ? sub->next : «NULL_LITERAL»;
			}
		}
		
		virtual ~Observable() = default;
	
	};
	'''
	
	override protected observableVoid()'''
	template<>
	class Observable<void> : public ObservableBase<void> {
	
	public:
		void next() {
			subscription<void> *sub = this->subscriptions;
			while (sub != «NULL_LITERAL») {
				if (*sub) {
					(*sub)->next();
				}
				sub = (sub->next != sub) ? sub->next : «NULL_LITERAL»;
			}
		}
		
		virtual ~Observable() = default;
	
	};
	'''
}