package com.yakindu.sct.generator.cpp11.files

import com.yakindu.sct.generator.cpp.files.TimerServiceHeader

class Cpp11TimerServiceHeader extends TimerServiceHeader{
	override includes(){
		super.includes() +
		'''
		«memoryInclude»
		#include <vector>
		#include <algorithm>
		'''
	}
	
	override protected tasksArrayMember()'''
	«uniquePtr»«timerServiceImplementationTask»[]«pointerType» tasks;
	'''
	
	override protected timerServiceConstructor()'''
	«timerServiceImplementation»(«uniquePtr»«timerServiceImplementationTask»[]«pointerType»&& tasks_, size_t length_) :
		length(length_), //
		tasks{std::move(tasks_)}, //
		next_active_task(length_), //
		next_free_task(0) // 
	{
		for (size_t i = 0; i < length; ++i) {
			tasks[i].next_task_idx = i+1;
		}
	}
	'''
	
	override resetHandle(String handle) {
		'''«handle»«freePointer»;'''
	}
	
	override protected taskDataDestructor()'''
	virtual ~TaskData() = default;
	'''
	
	override protected nullptrInit() ''''''
	
	override protected timeBasedInit() ''''''
}